/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.stabilityai.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.client.RestClient;

public class StabilityAiApi {
    public static final String DEFAULT_IMAGE_MODEL = "stable-diffusion-v1-6";
    public static final String DEFAULT_BASE_URL = "https://api.stability.ai/v1";
    private final RestClient restClient;
    private final String apiKey;
    private final String model;

    public StabilityAiApi(String apiKey) {
        this(apiKey, DEFAULT_IMAGE_MODEL, DEFAULT_BASE_URL, RestClient.builder());
    }

    public StabilityAiApi(String apiKey, String model) {
        this(apiKey, model, DEFAULT_BASE_URL, RestClient.builder());
    }

    public StabilityAiApi(String apiKey, String model, String baseUrl) {
        this(apiKey, model, baseUrl, RestClient.builder());
    }

    public StabilityAiApi(String apiKey, String model, String baseUrl, RestClient.Builder restClientBuilder) {
        this.model = model;
        this.apiKey = apiKey;
        Consumer<HttpHeaders> jsonContentHeaders = headers -> {
            headers.setBearerAuth(apiKey);
            headers.setAccept(List.of(MediaType.APPLICATION_JSON));
            headers.setContentType(MediaType.APPLICATION_JSON);
        };
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(jsonContentHeaders).defaultStatusHandler(RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER).build();
    }

    public GenerateImageResponse generateImage(GenerateImageRequest request) {
        Assert.notNull((Object)request, (String)"The request body can not be null.");
        return (GenerateImageResponse)((RestClient.RequestBodySpec)this.restClient.post().uri("/generation/{model}/text-to-image", new Object[]{this.model})).body((Object)request).retrieve().body(GenerateImageResponse.class);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record GenerateImageResponse(@JsonProperty(value="result") String result, @JsonProperty(value="artifacts") List<Artifacts> artifacts) {

        public record Artifacts(@JsonProperty(value="seed") long seed, @JsonProperty(value="base64") String base64, @JsonProperty(value="finishReason") String finishReason) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record GenerateImageRequest(@JsonProperty(value="text_prompts") List<TextPrompts> textPrompts, @JsonProperty(value="height") Integer height, @JsonProperty(value="width") Integer width, @JsonProperty(value="cfg_scale") Float cfgScale, @JsonProperty(value="clip_guidance_preset") String clipGuidancePreset, @JsonProperty(value="sampler") String sampler, @JsonProperty(value="samples") Integer samples, @JsonProperty(value="seed") Long seed, @JsonProperty(value="steps") Integer steps, @JsonProperty(value="style_preset") String stylePreset) {
        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            List<TextPrompts> textPrompts;
            Integer height;
            Integer width;
            Float cfgScale;
            String clipGuidancePreset;
            String sampler;
            Integer samples;
            Long seed;
            Integer steps;
            String stylePreset;

            public Builder textPrompts(List<TextPrompts> textPrompts) {
                this.textPrompts = textPrompts;
                return this;
            }

            public Builder height(Integer height) {
                this.height = height;
                return this;
            }

            public Builder width(Integer width) {
                this.width = width;
                return this;
            }

            public Builder cfgScale(Float cfgScale) {
                this.cfgScale = cfgScale;
                return this;
            }

            public Builder clipGuidancePreset(String clipGuidancePreset) {
                this.clipGuidancePreset = clipGuidancePreset;
                return this;
            }

            public Builder sampler(String sampler) {
                this.sampler = sampler;
                return this;
            }

            public Builder samples(Integer samples) {
                this.samples = samples;
                return this;
            }

            public Builder seed(Long seed) {
                this.seed = seed;
                return this;
            }

            public Builder steps(Integer steps) {
                this.steps = steps;
                return this;
            }

            public Builder stylePreset(String stylePreset) {
                this.stylePreset = stylePreset;
                return this;
            }

            public GenerateImageRequest build() {
                return new GenerateImageRequest(this.textPrompts, this.height, this.width, this.cfgScale, this.clipGuidancePreset, this.sampler, this.samples, this.seed, this.steps, this.stylePreset);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record TextPrompts(@JsonProperty(value="text") String text, @JsonProperty(value="weight") Float weight) {
        }
    }
}

