/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bindings;

import java.net.URI;
import java.util.Map;
import org.springframework.ai.bindings.BindingsValidator;
import org.springframework.cloud.bindings.Bindings;
import org.springframework.cloud.bindings.boot.BindingsPropertiesProcessor;
import org.springframework.core.env.Environment;

public class ChromaBindingsPropertiesProcessor
implements BindingsPropertiesProcessor {
    public static final String TYPE = "chroma";

    public void process(Environment environment, Bindings bindings, Map<String, Object> properties) {
        if (!BindingsValidator.isTypeEnabled(environment, TYPE)) {
            return;
        }
        bindings.filterBindings(TYPE).forEach(binding -> {
            URI uri = URI.create((String)binding.getSecret().get("uri"));
            properties.put("spring.ai.vectorstore.chroma.client.host", "%s://%s".formatted(uri.getScheme(), uri.getHost()));
            properties.put("spring.ai.vectorstore.chroma.client.port", String.valueOf(uri.getPort()));
            properties.put("spring.ai.vectorstore.chroma.client.username", binding.getSecret().get("username"));
            properties.put("spring.ai.vectorstore.chroma.client.password", binding.getSecret().get("password"));
        });
    }
}

