/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.testcontainers.service.connection.opensearch;

import java.util.List;
import org.opensearch.testcontainers.OpensearchContainer;
import org.springframework.ai.autoconfigure.vectorstore.opensearch.OpenSearchConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;

class OpenSearchContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<OpensearchContainer<?>, OpenSearchConnectionDetails> {
    OpenSearchContainerConnectionDetailsFactory() {
    }

    public OpenSearchConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<OpensearchContainer<?>> source) {
        return new OpenSearchContainerConnectionDetails(source);
    }

    private static final class OpenSearchContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<OpensearchContainer<?>>
    implements OpenSearchConnectionDetails {
        private OpenSearchContainerConnectionDetails(ContainerConnectionSource<OpensearchContainer<?>> source) {
            super(source);
        }

        public List<String> getUris() {
            return List.of(((OpensearchContainer)this.getContainer()).getHttpHostAddress());
        }

        public String getUsername() {
            return ((OpensearchContainer)this.getContainer()).isSecurityEnabled() ? ((OpensearchContainer)this.getContainer()).getUsername() : null;
        }

        public String getPassword() {
            return ((OpensearchContainer)this.getContainer()).isSecurityEnabled() ? ((OpensearchContainer)this.getContainer()).getPassword() : null;
        }
    }
}

