/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.docker.compose.service.connection.docker;

import java.util.Map;
import org.springframework.ai.mcp.client.common.autoconfigure.McpSseClientConnectionDetails;
import org.springframework.ai.mcp.client.common.autoconfigure.properties.McpSseClientProperties;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;

class DockerMcpGatewayDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<McpSseClientConnectionDetails> {
    private static final int GATEWAY_PORT = 8811;

    protected DockerMcpGatewayDockerComposeConnectionDetailsFactory() {
        super("docker/mcp-gateway", new String[0]);
    }

    protected McpSseClientConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new DockerAgentsGatewayContainerConnectionDetails(source.getRunningService());
    }

    static class DockerAgentsGatewayContainerConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements McpSseClientConnectionDetails {
        private final String url;

        DockerAgentsGatewayContainerConnectionDetails(RunningService service) {
            super(service);
            this.url = String.format("http://%s:%d", service.host(), service.ports().get(8811));
        }

        public Map<String, McpSseClientProperties.SseParameters> getConnections() {
            return Map.of("gateway", new McpSseClientProperties.SseParameters(this.url, "/sse"));
        }
    }
}

