/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.neo4j;

import io.micrometer.observation.ObservationRegistry;
import org.neo4j.driver.Driver;
import org.springframework.ai.autoconfigure.vectorstore.neo4j.Neo4jVectorStoreProperties;
import org.springframework.ai.embedding.BatchingStrategy;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.TokenCountBatchingStrategy;
import org.springframework.ai.vectorstore.neo4j.Neo4jVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationConvention;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.neo4j.Neo4jAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={Neo4jAutoConfiguration.class})
@ConditionalOnClass(value={Neo4jVectorStore.class, EmbeddingModel.class, Driver.class})
@EnableConfigurationProperties(value={Neo4jVectorStoreProperties.class})
public class Neo4jVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={BatchingStrategy.class})
    BatchingStrategy batchingStrategy() {
        return new TokenCountBatchingStrategy();
    }

    @Bean
    @ConditionalOnMissingBean
    public Neo4jVectorStore vectorStore(Driver driver, EmbeddingModel embeddingModel, Neo4jVectorStoreProperties properties, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<VectorStoreObservationConvention> customObservationConvention, BatchingStrategy batchingStrategy) {
        return ((Neo4jVectorStore.Builder)((Neo4jVectorStore.Builder)Neo4jVectorStore.builder((Driver)driver, (EmbeddingModel)embeddingModel).initializeSchema(properties.isInitializeSchema()).observationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP))).customObservationConvention((VectorStoreObservationConvention)customObservationConvention.getIfAvailable(() -> null))).batchingStrategy(batchingStrategy).databaseName(properties.getDatabaseName()).embeddingDimension(properties.getEmbeddingDimension()).distanceType(properties.getDistanceType()).label(properties.getLabel()).embeddingProperty(properties.getEmbeddingProperty()).indexName(properties.getIndexName()).idProperty(properties.getIdProperty()).constraintName(properties.getConstraintName()).build();
    }
}

