/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.milvus;

import io.milvus.client.MilvusServiceClient;
import io.milvus.param.ConnectParam;
import io.milvus.param.IndexType;
import io.milvus.param.MetricType;
import java.util.concurrent.TimeUnit;
import org.springframework.ai.autoconfigure.vectorstore.milvus.MilvusServiceClientProperties;
import org.springframework.ai.autoconfigure.vectorstore.milvus.MilvusVectorStoreProperties;
import org.springframework.ai.embedding.EmbeddingClient;
import org.springframework.ai.vectorstore.MilvusVectorStore;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnClass(value={MilvusVectorStore.class, EmbeddingClient.class})
@EnableConfigurationProperties(value={MilvusServiceClientProperties.class, MilvusVectorStoreProperties.class})
public class MilvusVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MilvusVectorStore vectorStore(MilvusServiceClient milvusClient, EmbeddingClient embeddingClient, MilvusVectorStoreProperties properties) {
        MilvusVectorStore.MilvusVectorStoreConfig config = MilvusVectorStore.MilvusVectorStoreConfig.builder().withCollectionName(properties.getCollectionName()).withDatabaseName(properties.getDatabaseName()).withIndexType(IndexType.valueOf((String)properties.getIndexType().name())).withMetricType(MetricType.valueOf((String)properties.getMetricType().name())).withIndexParameters(properties.getIndexParameters()).withEmbeddingDimension(properties.getEmbeddingDimension()).build();
        return new MilvusVectorStore(milvusClient, embeddingClient, config);
    }

    @Bean
    @ConditionalOnMissingBean
    public MilvusServiceClient milvusClient(MilvusVectorStoreProperties serverProperties, MilvusServiceClientProperties clientProperties) {
        ConnectParam.Builder builder = ConnectParam.newBuilder().withHost(clientProperties.getHost()).withPort(clientProperties.getPort()).withDatabaseName(serverProperties.getDatabaseName()).withConnectTimeout(clientProperties.getConnectTimeoutMs(), TimeUnit.MILLISECONDS).withKeepAliveTime(clientProperties.getKeepAliveTimeMs(), TimeUnit.MILLISECONDS).withKeepAliveTimeout(clientProperties.getKeepAliveTimeoutMs(), TimeUnit.MILLISECONDS).withRpcDeadline(clientProperties.getRpcDeadlineMs(), TimeUnit.MILLISECONDS).withSecure(clientProperties.isSecure()).withIdleTimeout(clientProperties.getIdleTimeoutMs(), TimeUnit.MILLISECONDS).withAuthorization(clientProperties.getUsername(), clientProperties.getPassword());
        if (clientProperties.isSecure() && StringUtils.hasText((String)clientProperties.getUri())) {
            builder.withUri(clientProperties.getUri());
        }
        if (clientProperties.isSecure() && StringUtils.hasText((String)clientProperties.getToken())) {
            builder.withToken(clientProperties.getToken());
        }
        if (clientProperties.isSecure() && StringUtils.hasText((String)clientProperties.getClientKeyPath())) {
            builder.withClientKeyPath(clientProperties.getClientKeyPath());
        }
        if (clientProperties.isSecure() && StringUtils.hasText((String)clientProperties.getClientPemPath())) {
            builder.withClientPemPath(clientProperties.getClientPemPath());
        }
        if (clientProperties.isSecure() && StringUtils.hasText((String)clientProperties.getCaPemPath())) {
            builder.withCaPemPath(clientProperties.getCaPemPath());
        }
        if (clientProperties.isSecure() && StringUtils.hasText((String)clientProperties.getServerPemPath())) {
            builder.withServerPemPath(clientProperties.getServerPemPath());
        }
        if (clientProperties.isSecure() && StringUtils.hasText((String)clientProperties.getServerName())) {
            builder.withServerName(clientProperties.getServerName());
        }
        return new MilvusServiceClient(builder.build());
    }
}

