/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.bedrock.titan;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.ai.autoconfigure.bedrock.BedrockAwsConnectionConfiguration;
import org.springframework.ai.autoconfigure.bedrock.BedrockAwsConnectionProperties;
import org.springframework.ai.autoconfigure.bedrock.titan.BedrockTitanEmbeddingProperties;
import org.springframework.ai.bedrock.titan.BedrockTitanEmbeddingClient;
import org.springframework.ai.bedrock.titan.api.TitanEmbeddingBedrockApi;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

@AutoConfiguration
@ConditionalOnClass(value={TitanEmbeddingBedrockApi.class})
@EnableConfigurationProperties(value={BedrockTitanEmbeddingProperties.class, BedrockAwsConnectionProperties.class})
@ConditionalOnProperty(prefix="spring.ai.bedrock.titan.embedding", name={"enabled"}, havingValue="true")
@Import(value={BedrockAwsConnectionConfiguration.class})
public class BedrockTitanEmbeddingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public TitanEmbeddingBedrockApi titanEmbeddingBedrockApi(AwsCredentialsProvider credentialsProvider, BedrockTitanEmbeddingProperties properties, BedrockAwsConnectionProperties awsProperties) {
        return new TitanEmbeddingBedrockApi(properties.getModel(), credentialsProvider, awsProperties.getRegion(), new ObjectMapper());
    }

    @Bean
    @ConditionalOnMissingBean
    public BedrockTitanEmbeddingClient titanEmbeddingClient(TitanEmbeddingBedrockApi titanEmbeddingApi, BedrockTitanEmbeddingProperties properties) {
        return new BedrockTitanEmbeddingClient(titanEmbeddingApi).withInputType(properties.getInputType());
    }
}

