/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.retry;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.retry.NonTransientAiException;
import org.springframework.ai.retry.TransientAiException;
import org.springframework.core.retry.RetryException;
import org.springframework.core.retry.RetryListener;
import org.springframework.core.retry.RetryPolicy;
import org.springframework.core.retry.RetryTemplate;
import org.springframework.core.retry.Retryable;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.util.StreamUtils;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.ResponseErrorHandler;

public abstract class RetryUtils {
    private static final int DEFAULT_MAX_ATTEMPTS = 10;
    private static final long DEFAULT_INITIAL_INTERVAL = 2000L;
    private static final int DEFAULT_MULTIPLIER = 5;
    private static final long DEFAULT_MAX_INTERVAL = 180000L;
    private static final long SHORT_INITIAL_INTERVAL = 100L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryUtils.class);
    public static final ResponseErrorHandler DEFAULT_RESPONSE_ERROR_HANDLER = new ResponseErrorHandler(){

        public boolean hasError(@NonNull ClientHttpResponse response) throws IOException {
            return response.getStatusCode().isError();
        }

        public void handleError(URI url, HttpMethod method, @NonNull ClientHttpResponse response) throws IOException {
            this.handleError(response);
        }

        public void handleError(@NonNull ClientHttpResponse response) throws IOException {
            if (response.getStatusCode().isError()) {
                String error = StreamUtils.copyToString((InputStream)response.getBody(), (Charset)StandardCharsets.UTF_8);
                String message = String.format("%s - %s", response.getStatusCode().value(), error);
                if (response.getStatusCode().is4xxClientError()) {
                    throw new NonTransientAiException(message);
                }
                throw new TransientAiException(message);
            }
        }
    };
    public static final RetryTemplate DEFAULT_RETRY_TEMPLATE = RetryUtils.createDefaultRetryTemplate();
    public static final RetryTemplate SHORT_RETRY_TEMPLATE = RetryUtils.createShortRetryTemplate();

    private static RetryTemplate createDefaultRetryTemplate() {
        RetryPolicy retryPolicy = RetryPolicy.builder().maxRetries(10L).includes(new Class[]{TransientAiException.class}).includes(new Class[]{ResourceAccessException.class}).delay(Duration.ofMillis(2000L)).multiplier(5.0).maxDelay(Duration.ofMillis(180000L)).build();
        RetryTemplate retryTemplate = new RetryTemplate(retryPolicy);
        retryTemplate.setRetryListener(new RetryListener(){
            private final AtomicInteger retryCount = new AtomicInteger(0);

            public void onRetryFailure(RetryPolicy policy, Retryable<?> retryable, Throwable throwable) {
                int currentRetries = this.retryCount.incrementAndGet();
                LOGGER.warn("Retry error. Retry count:{}", (Object)currentRetries, (Object)throwable);
            }
        });
        return retryTemplate;
    }

    private static RetryTemplate createShortRetryTemplate() {
        RetryPolicy retryPolicy = RetryPolicy.builder().maxRetries(10L).includes(new Class[]{TransientAiException.class}).includes(new Class[]{ResourceAccessException.class}).delay(Duration.ofMillis(100L)).build();
        RetryTemplate retryTemplate = new RetryTemplate(retryPolicy);
        retryTemplate.setRetryListener(new RetryListener(){
            private final AtomicInteger retryCount = new AtomicInteger(0);

            public void onRetryFailure(RetryPolicy policy, Retryable<?> retryable, Throwable throwable) {
                int currentRetries = this.retryCount.incrementAndGet();
                LOGGER.warn("Retry error. Retry count:{}", (Object)currentRetries, (Object)throwable);
            }
        });
        return retryTemplate;
    }

    public static <R> R execute(RetryTemplate retryTemplate, Retryable<R> retryable) {
        try {
            return (R)retryTemplate.execute(retryable);
        }
        catch (RetryException e) {
            RuntimeException runtime;
            Throwable throwable = e.getCause();
            throw throwable instanceof RuntimeException ? (runtime = (RuntimeException)throwable) : new RuntimeException(e.getMessage(), e.getCause());
        }
    }
}

