/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.redis.cache.semantic;

import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.vectorstore.redis.RedisVectorStore;
import redis.clients.jedis.JedisPooled;

public final class RedisVectorStoreHelper {
    private static final String DEFAULT_INDEX_NAME = "semantic-cache-idx";
    private static final String DEFAULT_PREFIX = "semantic-cache:";

    private RedisVectorStoreHelper() {
    }

    public static RedisVectorStore createVectorStore(JedisPooled jedis, EmbeddingModel embeddingModel) {
        return RedisVectorStoreHelper.createVectorStore(jedis, embeddingModel, DEFAULT_INDEX_NAME, DEFAULT_PREFIX);
    }

    public static RedisVectorStore createVectorStore(JedisPooled jedis, EmbeddingModel embeddingModel, String indexName, String prefix) {
        RedisVectorStore vectorStore = RedisVectorStore.builder((JedisPooled)jedis, (EmbeddingModel)embeddingModel).indexName(indexName).prefix(prefix).metadataFields(new RedisVectorStore.MetadataField[]{RedisVectorStore.MetadataField.text((String)"response"), RedisVectorStore.MetadataField.text((String)"response_text"), RedisVectorStore.MetadataField.numeric((String)"ttl")}).initializeSchema(true).build();
        vectorStore.afterPropertiesSet();
        return vectorStore;
    }
}

