/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.cache.semantic;

import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.chat.cache.semantic.SemanticCache;
import org.springframework.ai.chat.client.ChatClientRequest;
import org.springframework.ai.chat.client.ChatClientResponse;
import org.springframework.ai.chat.client.advisor.api.AdvisorChain;
import org.springframework.ai.chat.client.advisor.api.BaseChatMemoryAdvisor;
import org.springframework.ai.chat.client.advisor.api.CallAdvisorChain;
import org.springframework.ai.chat.client.advisor.api.StreamAdvisorChain;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class SemanticCacheAdvisor
implements BaseChatMemoryAdvisor {
    private final SemanticCache cache;
    private final int order;
    private final Scheduler scheduler;

    public SemanticCacheAdvisor(SemanticCache cache) {
        this(cache, -2147482648, Schedulers.boundedElastic());
    }

    public SemanticCacheAdvisor(SemanticCache cache, int order) {
        this(cache, order, Schedulers.boundedElastic());
    }

    public SemanticCacheAdvisor(SemanticCache cache, int order, Scheduler scheduler) {
        this.cache = cache;
        this.order = order;
        this.scheduler = scheduler;
    }

    public int getOrder() {
        return this.order;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public ChatClientResponse adviseCall(ChatClientRequest request, CallAdvisorChain chain) {
        String userText = this.extractUserTextFromRequest(request);
        Optional<ChatResponse> cached = this.cache.get(userText);
        if (cached.isPresent()) {
            return ChatClientResponse.builder().chatResponse(cached.get()).context(request.context()).build();
        }
        ChatClientResponse response = chain.nextCall(request);
        if (response.chatResponse() != null) {
            this.cache.set(userText, response.chatResponse());
        }
        return response;
    }

    public Flux<ChatClientResponse> adviseStream(ChatClientRequest request, StreamAdvisorChain chain) {
        String userText = this.extractUserTextFromRequest(request);
        Optional<ChatResponse> cached = this.cache.get(userText);
        if (cached.isPresent()) {
            return Flux.just((Object)ChatClientResponse.builder().chatResponse(cached.get()).context(request.context()).build());
        }
        return chain.nextStream(request).collectList().flatMapMany(responses -> {
            ChatClientResponse last;
            if (!responses.isEmpty() && (last = (ChatClientResponse)responses.get(responses.size() - 1)).chatResponse() != null) {
                this.cache.set(userText, last.chatResponse());
            }
            return Flux.fromIterable((Iterable)responses);
        });
    }

    public ChatClientRequest before(ChatClientRequest request, AdvisorChain advisorChain) {
        return request;
    }

    public ChatClientResponse after(ChatClientResponse response, AdvisorChain advisorChain) {
        return response;
    }

    private String extractUserTextFromRequest(ChatClientRequest request) {
        return Objects.requireNonNullElse(request.prompt().getUserMessage().getText(), "");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private @Nullable SemanticCache cache;
        private int order = -2147482648;
        private Scheduler scheduler = Schedulers.boundedElastic();

        public Builder cache(SemanticCache cache) {
            this.cache = cache;
            return this;
        }

        public Builder order(int order) {
            this.order = order;
            return this;
        }

        public Builder scheduler(Scheduler scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        public SemanticCacheAdvisor build() {
            Assert.notNull((Object)this.cache, (String)"Cache must not be null");
            return new SemanticCacheAdvisor(this.cache, this.order, this.scheduler);
        }
    }
}

