/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.rag.retrieval.join;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.rag.Query;
import org.springframework.ai.rag.retrieval.join.DocumentJoiner;
import org.springframework.util.Assert;

public class ConcatenationDocumentJoiner
implements DocumentJoiner {
    private static final Logger logger = LoggerFactory.getLogger(ConcatenationDocumentJoiner.class);

    @Override
    public List<Document> join(Map<Query, List<List<Document>>> documentsForQuery) {
        Assert.notNull(documentsForQuery, (String)"documentsForQuery cannot be null");
        Assert.noNullElements(documentsForQuery.keySet(), (String)"documentsForQuery cannot contain null keys");
        Assert.noNullElements(documentsForQuery.values(), (String)"documentsForQuery cannot contain null values");
        logger.debug("Joining documents by concatenation");
        return new ArrayList<Document>(documentsForQuery.values().stream().flatMap(Collection::stream).flatMap(Collection::stream).collect(Collectors.toMap(Document::getId, Function.identity(), (existing, duplicate) -> existing)).values().stream().sorted(Comparator.comparingDouble(doc -> doc.getScore() != null ? doc.getScore() : 0.0).reversed()).toList());
    }
}

