/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.rag.retrieval.search;

import java.util.List;
import java.util.function.Supplier;
import org.springframework.ai.document.Document;
import org.springframework.ai.rag.Query;
import org.springframework.ai.rag.retrieval.search.DocumentRetriever;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.VectorStore;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.FilterExpressionTextParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class VectorStoreDocumentRetriever
implements DocumentRetriever {
    public static final String FILTER_EXPRESSION = "vector_store_filter_expression";
    private final VectorStore vectorStore;
    private final Double similarityThreshold;
    private final Integer topK;
    private final Supplier<Filter.Expression> filterExpression;

    public VectorStoreDocumentRetriever(VectorStore vectorStore, @Nullable Double similarityThreshold, @Nullable Integer topK, @Nullable Supplier<Filter.Expression> filterExpression) {
        Assert.notNull((Object)vectorStore, (String)"vectorStore cannot be null");
        Assert.isTrue((similarityThreshold == null || similarityThreshold >= 0.0 ? 1 : 0) != 0, (String)"similarityThreshold must be equal to or greater than 0.0");
        Assert.isTrue((topK == null || topK > 0 ? 1 : 0) != 0, (String)"topK must be greater than 0");
        this.vectorStore = vectorStore;
        this.similarityThreshold = similarityThreshold != null ? similarityThreshold : 0.0;
        this.topK = topK != null ? topK : 4;
        this.filterExpression = filterExpression != null ? filterExpression : () -> null;
    }

    @Override
    public List<Document> retrieve(Query query) {
        Assert.notNull((Object)query, (String)"query cannot be null");
        Filter.Expression requestFilterExpression = this.computeRequestFilterExpression(query);
        SearchRequest searchRequest = SearchRequest.builder().query(query.text()).filterExpression(requestFilterExpression).similarityThreshold(this.similarityThreshold.doubleValue()).topK(this.topK.intValue()).build();
        return this.vectorStore.similaritySearch(searchRequest);
    }

    private Filter.Expression computeRequestFilterExpression(Query query) {
        Object contextFilterExpression = query.context().get(FILTER_EXPRESSION);
        if (contextFilterExpression != null && StringUtils.hasText((String)contextFilterExpression.toString())) {
            return new FilterExpressionTextParser().parse(contextFilterExpression.toString());
        }
        return this.filterExpression.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private VectorStore vectorStore;
        private Double similarityThreshold;
        private Integer topK;
        private Supplier<Filter.Expression> filterExpression;

        private Builder() {
        }

        public Builder vectorStore(VectorStore vectorStore) {
            this.vectorStore = vectorStore;
            return this;
        }

        public Builder similarityThreshold(Double similarityThreshold) {
            this.similarityThreshold = similarityThreshold;
            return this;
        }

        public Builder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public Builder filterExpression(Filter.Expression filterExpression) {
            this.filterExpression = () -> filterExpression;
            return this;
        }

        public Builder filterExpression(Supplier<Filter.Expression> filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public VectorStoreDocumentRetriever build() {
            return new VectorStoreDocumentRetriever(this.vectorStore, this.similarityThreshold, this.topK, this.filterExpression);
        }
    }
}

