/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.reader.pdf.aot;

import java.io.IOException;
import java.util.Set;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.lang.NonNull;

public class PdfReaderRuntimeHints
implements RuntimeHintsRegistrar {
    public void registerHints(@NonNull RuntimeHints hints, ClassLoader classLoader) {
        try {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            Set<String> patterns = Set.of("/org/apache/pdfbox/resources/glyphlist/zapfdingbats.txt", "/org/apache/pdfbox/resources/glyphlist/glyphlist.txt", "/org/apache/fontbox/cmap/**", "/org/apache/pdfbox/resources/afm/**", "/org/apache/pdfbox/resources/glyphlist/**", "/org/apache/pdfbox/resources/icc/**", "/org/apache/pdfbox/resources/text/**", "/org/apache/pdfbox/resources/ttf/**", "/org/apache/pdfbox/resources/version.properties");
            for (String pattern : patterns) {
                for (Resource resourceMatch : resolver.getResources(pattern)) {
                    hints.resources().registerResource(resourceMatch);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

