/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai.api;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Base64;

public class OpenAiEmbeddingDeserializer
extends JsonDeserializer<float[]> {
    public float[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
        JsonToken token = jsonParser.currentToken();
        if (token == JsonToken.START_ARRAY) {
            return (float[])jsonParser.readValueAs(float[].class);
        }
        if (token == JsonToken.VALUE_STRING) {
            String base64 = jsonParser.getValueAsString();
            byte[] decodedBytes = Base64.getDecoder().decode(base64);
            ByteBuffer byteBuffer = ByteBuffer.wrap(decodedBytes);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            int floatCount = decodedBytes.length / 4;
            float[] embeddingArray = new float[floatCount];
            for (int i = 0; i < floatCount; ++i) {
                embeddingArray[i] = byteBuffer.getFloat();
            }
            return embeddingArray;
        }
        throw new IOException("Illegal embedding: " + String.valueOf(token));
    }
}

