/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.NoopApiKey;
import org.springframework.ai.model.SimpleApiKey;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

public class OpenAiModerationApi {
    public static final String DEFAULT_MODERATION_MODEL = "text-moderation-latest";
    private static final String DEFAULT_BASE_URL = "https://api.openai.com";
    private final RestClient restClient;
    private final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public OpenAiModerationApi(String baseUrl, ApiKey apiKey, MultiValueMap<String, String> headers, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        this.restClient = restClientBuilder.clone().baseUrl(baseUrl).defaultHeaders(h -> {
            h.setContentType(MediaType.APPLICATION_JSON);
            h.addAll(headers);
        }).defaultStatusHandler(responseErrorHandler).defaultRequest(requestHeadersSpec -> {
            if (!(apiKey instanceof NoopApiKey)) {
                requestHeadersSpec.header("Authorization", new String[]{"Bearer " + apiKey.getValue()});
            }
        }).build();
    }

    public ResponseEntity<OpenAiModerationResponse> createModeration(OpenAiModerationRequest openAiModerationRequest) {
        Assert.notNull((Object)openAiModerationRequest, (String)"Moderation request cannot be null.");
        Assert.hasLength((String)openAiModerationRequest.prompt(), (String)"Prompt cannot be empty.");
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("v1/moderations", new Object[0])).body((Object)openAiModerationRequest).retrieve().toEntity(OpenAiModerationResponse.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record OpenAiModerationRequest(@JsonProperty(value="input") String prompt, @JsonProperty(value="model") String model) {
        public OpenAiModerationRequest(String prompt) {
            this(prompt, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record OpenAiModerationResponse(@JsonProperty(value="id") String id, @JsonProperty(value="model") String model, @JsonProperty(value="results") OpenAiModerationResult[] results) {
    }

    public static class Builder {
        private String baseUrl = "https://api.openai.com";
        private ApiKey apiKey;
        private MultiValueMap<String, String> headers = new LinkedMultiValueMap();
        private RestClient.Builder restClientBuilder = RestClient.builder();
        private ResponseErrorHandler responseErrorHandler = RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER;

        public Builder baseUrl(String baseUrl) {
            Assert.hasText((String)baseUrl, (String)"baseUrl cannot be null or empty");
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder apiKey(ApiKey apiKey) {
            Assert.notNull((Object)apiKey, (String)"apiKey cannot be null");
            this.apiKey = apiKey;
            return this;
        }

        public Builder apiKey(String simpleApiKey) {
            Assert.notNull((Object)simpleApiKey, (String)"simpleApiKey cannot be null");
            this.apiKey = new SimpleApiKey(simpleApiKey);
            return this;
        }

        public Builder headers(MultiValueMap<String, String> headers) {
            Assert.notNull(headers, (String)"headers cannot be null");
            this.headers = headers;
            return this;
        }

        public Builder restClientBuilder(RestClient.Builder restClientBuilder) {
            Assert.notNull((Object)restClientBuilder, (String)"restClientBuilder cannot be null");
            this.restClientBuilder = restClientBuilder;
            return this;
        }

        public Builder responseErrorHandler(ResponseErrorHandler responseErrorHandler) {
            Assert.notNull((Object)responseErrorHandler, (String)"responseErrorHandler cannot be null");
            this.responseErrorHandler = responseErrorHandler;
            return this;
        }

        public OpenAiModerationApi build() {
            Assert.notNull((Object)this.apiKey, (String)"apiKey must be set");
            return new OpenAiModerationApi(this.baseUrl, this.apiKey, this.headers, this.restClientBuilder, this.responseErrorHandler);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Data(@JsonProperty(value="url") String url, @JsonProperty(value="b64_json") String b64Json, @JsonProperty(value="revised_prompt") String revisedPrompt) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record CategoryScores(@JsonProperty(value="sexual") double sexual, @JsonProperty(value="hate") double hate, @JsonProperty(value="harassment") double harassment, @JsonProperty(value="self-harm") double selfHarm, @JsonProperty(value="sexual/minors") double sexualMinors, @JsonProperty(value="hate/threatening") double hateThreatening, @JsonProperty(value="violence/graphic") double violenceGraphic, @JsonProperty(value="self-harm/intent") double selfHarmIntent, @JsonProperty(value="self-harm/instructions") double selfHarmInstructions, @JsonProperty(value="harassment/threatening") double harassmentThreatening, @JsonProperty(value="violence") double violence) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Categories(@JsonProperty(value="sexual") boolean sexual, @JsonProperty(value="hate") boolean hate, @JsonProperty(value="harassment") boolean harassment, @JsonProperty(value="self-harm") boolean selfHarm, @JsonProperty(value="sexual/minors") boolean sexualMinors, @JsonProperty(value="hate/threatening") boolean hateThreatening, @JsonProperty(value="violence/graphic") boolean violenceGraphic, @JsonProperty(value="self-harm/intent") boolean selfHarmIntent, @JsonProperty(value="self-harm/instructions") boolean selfHarmInstructions, @JsonProperty(value="harassment/threatening") boolean harassmentThreatening, @JsonProperty(value="violence") boolean violence) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record OpenAiModerationResult(@JsonProperty(value="flagged") boolean flagged, @JsonProperty(value="categories") Categories categories, @JsonProperty(value="category_scores") CategoryScores categoryScores) {
    }
}

