/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openaisdk.metadata;

import com.openai.models.images.ImagesResponse;
import java.util.Objects;
import org.springframework.ai.image.ImageResponseMetadata;
import org.springframework.util.Assert;

public class OpenAiSdkImageResponseMetadata
extends ImageResponseMetadata {
    private final Long created;

    protected OpenAiSdkImageResponseMetadata(Long created) {
        this.created = created;
    }

    public static OpenAiSdkImageResponseMetadata from(ImagesResponse imagesResponse) {
        Assert.notNull((Object)imagesResponse, (String)"imagesResponse must not be null");
        return new OpenAiSdkImageResponseMetadata(imagesResponse.created());
    }

    public Long getCreated() {
        return this.created;
    }

    public String toString() {
        return "OpenAiSdkImageResponseMetadata{created=" + this.created + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenAiSdkImageResponseMetadata)) {
            return false;
        }
        OpenAiSdkImageResponseMetadata that = (OpenAiSdkImageResponseMetadata)((Object)o);
        return Objects.equals(this.created, that.created);
    }

    public int hashCode() {
        return Objects.hash(this.created);
    }
}

