/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.ollama.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.ollama.api.OllamaApiHelper;
import org.springframework.ai.ollama.api.OllamaChatOptions;
import org.springframework.ai.ollama.api.ThinkOption;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class OllamaApi {
    public static final String REQUEST_BODY_NULL_ERROR = "The request body can not be null.";
    private static final Log logger = LogFactory.getLog(OllamaApi.class);
    private final RestClient restClient;
    private final WebClient webClient;

    public static Builder builder() {
        return new Builder();
    }

    private OllamaApi(String baseUrl, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler) {
        Consumer<HttpHeaders> defaultHeaders = headers -> {
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        };
        this.restClient = restClientBuilder.clone().baseUrl(baseUrl).defaultHeaders(defaultHeaders).defaultStatusHandler(responseErrorHandler).build();
        this.webClient = webClientBuilder.clone().baseUrl(baseUrl).defaultHeaders(defaultHeaders).build();
    }

    public ChatResponse chat(ChatRequest chatRequest) {
        Assert.notNull((Object)chatRequest, (String)REQUEST_BODY_NULL_ERROR);
        Assert.isTrue((chatRequest.stream() == false ? 1 : 0) != 0, (String)"Stream mode must be disabled.");
        return (ChatResponse)((RestClient.RequestBodySpec)this.restClient.post().uri("/api/chat", new Object[0])).body((Object)chatRequest).retrieve().body(ChatResponse.class);
    }

    public Flux<ChatResponse> streamingChat(ChatRequest chatRequest) {
        Assert.notNull((Object)chatRequest, (String)REQUEST_BODY_NULL_ERROR);
        Assert.isTrue((boolean)chatRequest.stream(), (String)"Request must set the stream property to true.");
        AtomicBoolean isInsideTool = new AtomicBoolean(false);
        return ((WebClient.RequestBodySpec)this.webClient.post().uri("/api/chat", new Object[0])).body((Publisher)Mono.just((Object)chatRequest), ChatRequest.class).retrieve().bodyToFlux(ChatResponse.class).map(chunk -> {
            if (OllamaApiHelper.isStreamingToolCall(chunk)) {
                isInsideTool.set(true);
            }
            return chunk;
        }).windowUntil(chunk -> {
            if (isInsideTool.get() && OllamaApiHelper.isStreamingDone(chunk)) {
                isInsideTool.set(false);
                return true;
            }
            return !isInsideTool.get();
        }).concatMapIterable(window -> {
            Mono monoChunk = window.reduce((Object)new ChatResponse(), (previous, current) -> OllamaApiHelper.merge(previous, current));
            return List.of(monoChunk);
        }).flatMap(mono -> mono).handle((data, sink) -> {
            if (logger.isTraceEnabled()) {
                logger.trace(data);
            }
            sink.next(data);
        });
    }

    public EmbeddingsResponse embed(EmbeddingsRequest embeddingsRequest) {
        Assert.notNull((Object)embeddingsRequest, (String)REQUEST_BODY_NULL_ERROR);
        return (EmbeddingsResponse)((RestClient.RequestBodySpec)this.restClient.post().uri("/api/embed", new Object[0])).body((Object)embeddingsRequest).retrieve().body(EmbeddingsResponse.class);
    }

    public ListModelResponse listModels() {
        return (ListModelResponse)this.restClient.get().uri("/api/tags", new Object[0]).retrieve().body(ListModelResponse.class);
    }

    public ShowModelResponse showModel(ShowModelRequest showModelRequest) {
        Assert.notNull((Object)showModelRequest, (String)"showModelRequest must not be null");
        return (ShowModelResponse)((RestClient.RequestBodySpec)this.restClient.post().uri("/api/show", new Object[0])).body((Object)showModelRequest).retrieve().body(ShowModelResponse.class);
    }

    public ResponseEntity<Void> copyModel(CopyModelRequest copyModelRequest) {
        Assert.notNull((Object)copyModelRequest, (String)"copyModelRequest must not be null");
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/api/copy", new Object[0])).body((Object)copyModelRequest).retrieve().toBodilessEntity();
    }

    public ResponseEntity<Void> deleteModel(DeleteModelRequest deleteModelRequest) {
        Assert.notNull((Object)deleteModelRequest, (String)"deleteModelRequest must not be null");
        return ((RestClient.RequestBodySpec)this.restClient.method(HttpMethod.DELETE).uri("/api/delete", new Object[0])).body((Object)deleteModelRequest).retrieve().toBodilessEntity();
    }

    public Flux<ProgressResponse> pullModel(PullModelRequest pullModelRequest) {
        Assert.notNull((Object)pullModelRequest, (String)"pullModelRequest must not be null");
        Assert.isTrue((boolean)pullModelRequest.stream(), (String)"Request must set the stream property to true.");
        return ((WebClient.RequestBodySpec)this.webClient.post().uri("/api/pull", new Object[0])).bodyValue((Object)pullModelRequest).retrieve().bodyToFlux(ProgressResponse.class);
    }

    public static final class Builder {
        private String baseUrl = "http://localhost:11434";
        private RestClient.Builder restClientBuilder = RestClient.builder();
        private WebClient.Builder webClientBuilder = WebClient.builder();
        private ResponseErrorHandler responseErrorHandler = RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER;

        public Builder baseUrl(String baseUrl) {
            Assert.hasText((String)baseUrl, (String)"baseUrl cannot be null or empty");
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder restClientBuilder(RestClient.Builder restClientBuilder) {
            Assert.notNull((Object)restClientBuilder, (String)"restClientBuilder cannot be null");
            this.restClientBuilder = restClientBuilder;
            return this;
        }

        public Builder webClientBuilder(WebClient.Builder webClientBuilder) {
            Assert.notNull((Object)webClientBuilder, (String)"webClientBuilder cannot be null");
            this.webClientBuilder = webClientBuilder;
            return this;
        }

        public Builder responseErrorHandler(ResponseErrorHandler responseErrorHandler) {
            Assert.notNull((Object)responseErrorHandler, (String)"responseErrorHandler cannot be null");
            this.responseErrorHandler = responseErrorHandler;
            return this;
        }

        public OllamaApi build() {
            return new OllamaApi(this.baseUrl, this.restClientBuilder, this.webClientBuilder, this.responseErrorHandler);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatRequest(@JsonProperty(value="model") String model, @JsonProperty(value="messages") List<Message> messages, @JsonProperty(value="stream") Boolean stream, @JsonProperty(value="format") Object format, @JsonProperty(value="keep_alive") String keepAlive, @JsonProperty(value="tools") List<Tool> tools, @JsonProperty(value="options") Map<String, Object> options, @JsonProperty(value="think") ThinkOption think) {
        public static Builder builder(String model) {
            return new Builder(model);
        }

        public static final class Builder {
            private final String model;
            private List<Message> messages = List.of();
            private boolean stream = false;
            private Object format;
            private String keepAlive;
            private List<Tool> tools = List.of();
            private Map<String, Object> options = Map.of();
            private ThinkOption think;

            public Builder(String model) {
                Assert.notNull((Object)model, (String)"The model can not be null.");
                this.model = model;
            }

            public Builder messages(List<Message> messages) {
                this.messages = messages;
                return this;
            }

            public Builder stream(boolean stream) {
                this.stream = stream;
                return this;
            }

            public Builder format(Object format) {
                this.format = format;
                return this;
            }

            public Builder keepAlive(String keepAlive) {
                this.keepAlive = keepAlive;
                return this;
            }

            public Builder tools(List<Tool> tools) {
                this.tools = tools;
                return this;
            }

            public Builder options(Map<String, Object> options) {
                Objects.requireNonNull(options, "The options can not be null.");
                this.options = OllamaChatOptions.filterNonSupportedFields(options);
                return this;
            }

            public Builder think(ThinkOption think) {
                this.think = think;
                return this;
            }

            public Builder enableThinking() {
                this.think = ThinkOption.ThinkBoolean.ENABLED;
                return this;
            }

            public Builder disableThinking() {
                this.think = ThinkOption.ThinkBoolean.DISABLED;
                return this;
            }

            public Builder thinkLow() {
                this.think = ThinkOption.ThinkLevel.LOW;
                return this;
            }

            public Builder thinkMedium() {
                this.think = ThinkOption.ThinkLevel.MEDIUM;
                return this;
            }

            public Builder thinkHigh() {
                this.think = ThinkOption.ThinkLevel.HIGH;
                return this;
            }

            public Builder options(OllamaChatOptions options) {
                Objects.requireNonNull(options, "The options can not be null.");
                this.options = OllamaChatOptions.filterNonSupportedFields(options.toMap());
                return this;
            }

            public ChatRequest build() {
                return new ChatRequest(this.model, this.messages, this.stream, this.format, this.keepAlive, this.tools, this.options, this.think);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Tool(@JsonProperty(value="type") Type type, @JsonProperty(value="function") Function function) {
            public Tool(Function function) {
                this(Type.FUNCTION, function);
            }

            public static enum Type {
                FUNCTION;

            }

            public record Function(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="parameters") Map<String, Object> parameters) {
                public Function(String description, String name, String jsonSchema) {
                    this(description, name, ModelOptionsUtils.jsonToMap((String)jsonSchema));
                }
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ChatResponse(@JsonProperty(value="model") String model, @JsonProperty(value="created_at") Instant createdAt, @JsonProperty(value="message") Message message, @JsonProperty(value="done_reason") String doneReason, @JsonProperty(value="done") Boolean done, @JsonProperty(value="total_duration") Long totalDuration, @JsonProperty(value="load_duration") Long loadDuration, @JsonProperty(value="prompt_eval_count") Integer promptEvalCount, @JsonProperty(value="prompt_eval_duration") Long promptEvalDuration, @JsonProperty(value="eval_count") Integer evalCount, @JsonProperty(value="eval_duration") Long evalDuration) {
        ChatResponse() {
            this(null, null, null, null, null, null, null, null, null, null, null);
        }

        public Duration getTotalDuration() {
            return this.totalDuration() != null ? Duration.ofNanos(this.totalDuration()) : null;
        }

        public Duration getLoadDuration() {
            return this.loadDuration() != null ? Duration.ofNanos(this.loadDuration()) : null;
        }

        public Duration getPromptEvalDuration() {
            return this.promptEvalDuration() != null ? Duration.ofNanos(this.promptEvalDuration()) : null;
        }

        public Duration getEvalDuration() {
            if (this.evalDuration() == null) {
                return null;
            }
            return Duration.ofNanos(this.evalDuration());
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record EmbeddingsResponse(@JsonProperty(value="model") String model, @JsonProperty(value="embeddings") List<float[]> embeddings, @JsonProperty(value="total_duration") Long totalDuration, @JsonProperty(value="load_duration") Long loadDuration, @JsonProperty(value="prompt_eval_count") Integer promptEvalCount) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ListModelResponse(@JsonProperty(value="models") List<Model> models) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ShowModelResponse(@JsonProperty(value="license") String license, @JsonProperty(value="modelfile") String modelfile, @JsonProperty(value="parameters") String parameters, @JsonProperty(value="template") String template, @JsonProperty(value="system") String system, @JsonProperty(value="details") Model.Details details, @JsonProperty(value="messages") List<Message> messages, @JsonProperty(value="model_info") Map<String, Object> modelInfo, @JsonProperty(value="projector_info") Map<String, Object> projectorInfo, @JsonProperty(value="capabilities") List<String> capabilities, @JsonProperty(value="modified_at") Instant modifiedAt) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record PullModelRequest(@JsonProperty(value="model") String model, @JsonProperty(value="insecure") boolean insecure, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="stream") boolean stream) {
        public PullModelRequest {
            if (!stream) {
                logger.warn((Object)"Enforcing streaming of the model pull request");
            }
            stream = true;
        }

        public PullModelRequest(String model) {
            this(model, false, null, null, true);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ProgressResponse(@JsonProperty(value="status") String status, @JsonProperty(value="digest") String digest, @JsonProperty(value="total") Long total, @JsonProperty(value="completed") Long completed) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DeleteModelRequest(@JsonProperty(value="model") String model) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record CopyModelRequest(@JsonProperty(value="source") String source, @JsonProperty(value="destination") String destination) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ShowModelRequest(@JsonProperty(value="model") String model, @JsonProperty(value="system") String system, @JsonProperty(value="verbose") Boolean verbose, @JsonProperty(value="options") Map<String, Object> options) {
        public ShowModelRequest(String model) {
            this(model, null, null, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Model(@JsonProperty(value="name") String name, @JsonProperty(value="model") String model, @JsonProperty(value="modified_at") Instant modifiedAt, @JsonProperty(value="size") Long size, @JsonProperty(value="digest") String digest, @JsonProperty(value="details") Details details) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record Details(@JsonProperty(value="parent_model") String parentModel, @JsonProperty(value="format") String format, @JsonProperty(value="family") String family, @JsonProperty(value="families") List<String> families, @JsonProperty(value="parameter_size") String parameterSize, @JsonProperty(value="quantization_level") String quantizationLevel) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record EmbeddingsRequest(@JsonProperty(value="model") String model, @JsonProperty(value="input") List<String> input, @JsonProperty(value="keep_alive") String keepAlive, @JsonProperty(value="options") Map<String, Object> options, @JsonProperty(value="truncate") Boolean truncate) {
        public EmbeddingsRequest(String model, String input) {
            this(model, List.of(input), null, null, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Message(@JsonProperty(value="role") Role role, @JsonProperty(value="content") String content, @JsonProperty(value="images") List<String> images, @JsonProperty(value="tool_calls") List<ToolCall> toolCalls, @JsonProperty(value="tool_name") String toolName, @JsonProperty(value="thinking") String thinking) {
        public static Builder builder(Role role) {
            return new Builder(role);
        }

        public static enum Role {
            SYSTEM,
            USER,
            ASSISTANT,
            TOOL;

        }

        public static final class Builder {
            private final Role role;
            private String content;
            private List<String> images;
            private List<ToolCall> toolCalls;
            private String toolName;
            private String thinking;

            public Builder(Role role) {
                this.role = role;
            }

            public Builder content(String content) {
                this.content = content;
                return this;
            }

            public Builder images(List<String> images) {
                this.images = images;
                return this;
            }

            public Builder toolCalls(List<ToolCall> toolCalls) {
                this.toolCalls = toolCalls;
                return this;
            }

            public Builder toolName(String toolName) {
                this.toolName = toolName;
                return this;
            }

            public Builder thinking(String thinking) {
                this.thinking = thinking;
                return this;
            }

            public Message build() {
                return new Message(this.role, this.content, this.images, this.toolCalls, this.toolName, this.thinking);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ToolCallFunction(@JsonProperty(value="name") String name, @JsonProperty(value="arguments") Map<String, Object> arguments, @JsonProperty(value="index") Integer index) {
            public ToolCallFunction(String name, Map<String, Object> arguments) {
                this(name, arguments, null);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ToolCall(@JsonProperty(value="function") ToolCallFunction function) {
        }
    }
}

