/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.ollama.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.ollama.api.OllamaModel;
import org.springframework.ai.ollama.api.OllamaOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OllamaEmbeddingOptions
implements EmbeddingOptions {
    private static final List<String> NON_SUPPORTED_FIELDS = List.of("model", "keep_alive", "truncate");
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="keep_alive")
    private String keepAlive;
    @JsonProperty(value="truncate")
    private Boolean truncate;
    @JsonProperty(value="numa")
    private Boolean useNUMA;
    @JsonProperty(value="num_batch")
    private Integer numBatch;
    @JsonProperty(value="num_gpu")
    private Integer numGPU;
    @JsonProperty(value="main_gpu")
    private Integer mainGPU;
    @JsonProperty(value="low_vram")
    private Boolean lowVRAM;
    @JsonProperty(value="vocab_only")
    private Boolean vocabOnly;
    @JsonProperty(value="use_mmap")
    private Boolean useMMap;
    @JsonProperty(value="use_mlock")
    private Boolean useMLock;
    @JsonProperty(value="num_thread")
    private Integer numThread;

    public static Builder builder() {
        return new Builder();
    }

    public static Map<String, Object> filterNonSupportedFields(Map<String, Object> options) {
        return options.entrySet().stream().filter(e -> !NON_SUPPORTED_FIELDS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static OllamaEmbeddingOptions fromOptions(OllamaEmbeddingOptions fromOptions) {
        return OllamaEmbeddingOptions.builder().model(fromOptions.getModel()).keepAlive(fromOptions.getKeepAlive()).truncate(fromOptions.getTruncate()).useNUMA(fromOptions.getUseNUMA()).numBatch(fromOptions.getNumBatch()).numGPU(fromOptions.getNumGPU()).mainGPU(fromOptions.getMainGPU()).lowVRAM(fromOptions.getLowVRAM()).vocabOnly(fromOptions.getVocabOnly()).useMMap(fromOptions.getUseMMap()).useMLock(fromOptions.getUseMLock()).numThread(fromOptions.getNumThread()).build();
    }

    public static OllamaEmbeddingOptions fromOptions(OllamaOptions fromOptions) {
        return OllamaEmbeddingOptions.builder().model(fromOptions.getModel()).keepAlive(fromOptions.getKeepAlive()).truncate(fromOptions.getTruncate()).useNUMA(fromOptions.getUseNUMA()).numBatch(fromOptions.getNumBatch()).numGPU(fromOptions.getNumGPU()).mainGPU(fromOptions.getMainGPU()).lowVRAM(fromOptions.getLowVRAM()).vocabOnly(fromOptions.getVocabOnly()).useMMap(fromOptions.getUseMMap()).useMLock(fromOptions.getUseMLock()).numThread(fromOptions.getNumThread()).build();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(String keepAlive) {
        this.keepAlive = keepAlive;
    }

    public Boolean getTruncate() {
        return this.truncate;
    }

    public void setTruncate(Boolean truncate) {
        this.truncate = truncate;
    }

    public Boolean getUseNUMA() {
        return this.useNUMA;
    }

    public void setUseNUMA(Boolean useNUMA) {
        this.useNUMA = useNUMA;
    }

    public Integer getNumBatch() {
        return this.numBatch;
    }

    public void setNumBatch(Integer numBatch) {
        this.numBatch = numBatch;
    }

    public Integer getNumGPU() {
        return this.numGPU;
    }

    public void setNumGPU(Integer numGPU) {
        this.numGPU = numGPU;
    }

    public Integer getMainGPU() {
        return this.mainGPU;
    }

    public void setMainGPU(Integer mainGPU) {
        this.mainGPU = mainGPU;
    }

    public Boolean getLowVRAM() {
        return this.lowVRAM;
    }

    public void setLowVRAM(Boolean lowVRAM) {
        this.lowVRAM = lowVRAM;
    }

    public Boolean getVocabOnly() {
        return this.vocabOnly;
    }

    public void setVocabOnly(Boolean vocabOnly) {
        this.vocabOnly = vocabOnly;
    }

    public Boolean getUseMMap() {
        return this.useMMap;
    }

    public void setUseMMap(Boolean useMMap) {
        this.useMMap = useMMap;
    }

    public Boolean getUseMLock() {
        return this.useMLock;
    }

    public void setUseMLock(Boolean useMLock) {
        this.useMLock = useMLock;
    }

    public Integer getNumThread() {
        return this.numThread;
    }

    public void setNumThread(Integer numThread) {
        this.numThread = numThread;
    }

    @JsonIgnore
    public Integer getDimensions() {
        return null;
    }

    public Map<String, Object> toMap() {
        return ModelOptionsUtils.objectToMap((Object)this);
    }

    public OllamaEmbeddingOptions copy() {
        return OllamaEmbeddingOptions.fromOptions(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OllamaEmbeddingOptions that = (OllamaEmbeddingOptions)o;
        return Objects.equals(this.model, that.model) && Objects.equals(this.keepAlive, that.keepAlive) && Objects.equals(this.truncate, that.truncate);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.keepAlive, this.truncate);
    }

    public static final class Builder {
        private final OllamaEmbeddingOptions options = new OllamaEmbeddingOptions();

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder model(OllamaModel model) {
            this.options.model = model.getName();
            return this;
        }

        public Builder keepAlive(String keepAlive) {
            this.options.keepAlive = keepAlive;
            return this;
        }

        public Builder truncate(Boolean truncate) {
            this.options.truncate = truncate;
            return this;
        }

        public Builder useNUMA(Boolean useNUMA) {
            this.options.useNUMA = useNUMA;
            return this;
        }

        public Builder numBatch(Integer numBatch) {
            this.options.numBatch = numBatch;
            return this;
        }

        public Builder numGPU(Integer numGPU) {
            this.options.numGPU = numGPU;
            return this;
        }

        public Builder mainGPU(Integer mainGPU) {
            this.options.mainGPU = mainGPU;
            return this;
        }

        public Builder lowVRAM(Boolean lowVRAM) {
            this.options.lowVRAM = lowVRAM;
            return this;
        }

        public Builder vocabOnly(Boolean vocabOnly) {
            this.options.vocabOnly = vocabOnly;
            return this;
        }

        public Builder useMMap(Boolean useMMap) {
            this.options.useMMap = useMMap;
            return this;
        }

        public Builder useMLock(Boolean useMLock) {
            this.options.useMLock = useMLock;
            return this;
        }

        public Builder numThread(Integer numThread) {
            this.options.numThread = numThread;
            return this;
        }

        public OllamaEmbeddingOptions build() {
            return this.options;
        }
    }
}

