/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.tool.resolution;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.resolution.ToolCallbackResolver;
import org.springframework.util.Assert;

public class DelegatingToolCallbackResolver
implements ToolCallbackResolver {
    private final List<ToolCallbackResolver> toolCallbackResolvers;

    public DelegatingToolCallbackResolver(List<ToolCallbackResolver> toolCallbackResolvers) {
        Assert.notNull(toolCallbackResolvers, (String)"toolCallbackResolvers cannot be null");
        Assert.noNullElements(toolCallbackResolvers, (String)"toolCallbackResolvers cannot contain null elements");
        this.toolCallbackResolvers = toolCallbackResolvers;
    }

    @Override
    public @Nullable ToolCallback resolve(String toolName) {
        Assert.hasText((String)toolName, (String)"toolName cannot be null or empty");
        for (ToolCallbackResolver toolCallbackResolver : this.toolCallbackResolvers) {
            ToolCallback toolCallback = toolCallbackResolver.resolve(toolName);
            if (toolCallback == null) continue;
            return toolCallback;
        }
        return null;
    }
}

