/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.tool.definition;

import org.jspecify.annotations.Nullable;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.ai.util.ParsingUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public record DefaultToolDefinition(String name, String description, String inputSchema) implements ToolDefinition
{
    public DefaultToolDefinition {
        Assert.hasText((String)name, (String)"name cannot be null or empty");
        Assert.hasText((String)description, (String)"description cannot be null or empty");
        Assert.hasText((String)inputSchema, (String)"inputSchema cannot be null or empty");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private @Nullable String name;
        private @Nullable String description;
        private @Nullable String inputSchema;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder inputSchema(String inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public ToolDefinition build() {
            Assert.state((this.name != null ? 1 : 0) != 0, (String)"toolName cannot be null or empty");
            if (!StringUtils.hasText((String)this.description)) {
                this.description = ParsingUtils.reConcatenateCamelCase((String)this.name, (String)" ");
            }
            Assert.state((this.description != null ? 1 : 0) != 0, (String)"toolDescription cannot be null or empty");
            Assert.state((this.inputSchema != null ? 1 : 0) != 0, (String)"inputSchema cannot be null or empty");
            return new DefaultToolDefinition(this.name, this.description, this.inputSchema);
        }
    }
}

