/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.embedding.observation;

import org.jspecify.annotations.Nullable;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.model.observation.ModelObservationContext;
import org.springframework.ai.observation.AiOperationMetadata;
import org.springframework.ai.observation.conventions.AiOperationType;
import org.springframework.util.Assert;

public class EmbeddingModelObservationContext
extends ModelObservationContext<EmbeddingRequest, EmbeddingResponse> {
    EmbeddingModelObservationContext(EmbeddingRequest embeddingRequest, String provider) {
        super(embeddingRequest, AiOperationMetadata.builder().operationType(AiOperationType.EMBEDDING.value()).provider(provider).build());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private @Nullable EmbeddingRequest embeddingRequest;
        private @Nullable String provider;

        private Builder() {
        }

        public Builder embeddingRequest(EmbeddingRequest embeddingRequest) {
            this.embeddingRequest = embeddingRequest;
            return this;
        }

        public Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public EmbeddingModelObservationContext build() {
            Assert.state((this.embeddingRequest != null ? 1 : 0) != 0, (String)"request cannot be null");
            Assert.state((this.provider != null ? 1 : 0) != 0, (String)"provider cannot be null or empty");
            return new EmbeddingModelObservationContext(this.embeddingRequest, this.provider);
        }
    }
}

