/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.embedding;

import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.BatchingStrategy;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.model.Model;
import org.springframework.util.Assert;

public interface EmbeddingModel
extends Model<EmbeddingRequest, EmbeddingResponse> {
    @Override
    public EmbeddingResponse call(EmbeddingRequest var1);

    default public float[] embed(String text) {
        Assert.notNull((Object)text, (String)"Text must not be null");
        List<float[]> response = this.embed(List.of(text));
        return response.iterator().next();
    }

    public float[] embed(Document var1);

    default public List<float[]> embed(List<String> texts) {
        Assert.notNull(texts, (String)"Texts must not be null");
        return this.call(new EmbeddingRequest(texts, EmbeddingOptions.builder().build())).getResults().stream().map(Embedding::getOutput).toList();
    }

    default public List<float[]> embed(List<Document> documents, @Nullable EmbeddingOptions options, BatchingStrategy batchingStrategy) {
        Assert.notNull(documents, (String)"Documents must not be null");
        ArrayList<float[]> embeddings = new ArrayList<float[]>(documents.size());
        List<List<Document>> batch = batchingStrategy.batch(documents);
        for (List<Document> subBatch : batch) {
            List<String> texts = subBatch.stream().map(Document::getText).toList();
            EmbeddingRequest request = new EmbeddingRequest(texts, options);
            EmbeddingResponse response = this.call(request);
            for (int i = 0; i < subBatch.size(); ++i) {
                embeddings.add(response.getResults().get(i).getOutput());
            }
        }
        Assert.isTrue((embeddings.size() == documents.size() ? 1 : 0) != 0, (String)"Embeddings must have the same number as that of the documents");
        return embeddings;
    }

    default public EmbeddingResponse embedForResponse(List<String> texts) {
        Assert.notNull(texts, (String)"Texts must not be null");
        return this.call(new EmbeddingRequest(texts, EmbeddingOptions.builder().build()));
    }

    default public int dimensions() {
        return this.embed("Test String").length;
    }
}

