/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.audio.tts;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.audio.tts.TextToSpeechOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class DefaultTextToSpeechOptions
implements TextToSpeechOptions {
    private final @Nullable String model;
    private final @Nullable String voice;
    private final @Nullable String format;
    private final @Nullable Double speed;

    private DefaultTextToSpeechOptions(@Nullable String model, @Nullable String voice, @Nullable String format, @Nullable Double speed) {
        this.model = model;
        this.voice = voice;
        this.format = format;
        this.speed = speed;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public @Nullable String getModel() {
        return this.model;
    }

    @Override
    public @Nullable String getVoice() {
        return this.voice;
    }

    @Override
    public @Nullable String getFormat() {
        return this.format;
    }

    @Override
    public @Nullable Double getSpeed() {
        return this.speed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultTextToSpeechOptions)) {
            return false;
        }
        DefaultTextToSpeechOptions that = (DefaultTextToSpeechOptions)o;
        return Objects.equals(this.model, that.model) && Objects.equals(this.voice, that.voice) && Objects.equals(this.format, that.format) && Objects.equals(this.speed, that.speed);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.voice, this.format, this.speed);
    }

    public String toString() {
        return "DefaultTextToSpeechOptions{model='" + this.model + "', voice='" + this.voice + "', format='" + this.format + "', speed=" + this.speed + "}";
    }

    public DefaultTextToSpeechOptions copy() {
        return new Builder(this).build();
    }

    public static final class Builder
    implements TextToSpeechOptions.Builder {
        private @Nullable String model;
        private @Nullable String voice;
        private @Nullable String format;
        private @Nullable Double speed;

        public Builder() {
        }

        private Builder(DefaultTextToSpeechOptions options) {
            this.model = options.model;
            this.voice = options.voice;
            this.format = options.format;
            this.speed = options.speed;
        }

        @Override
        public Builder model(String model) {
            this.model = model;
            return this;
        }

        @Override
        public Builder voice(String voice) {
            this.voice = voice;
            return this;
        }

        @Override
        public Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public Builder speed(Double speed) {
            this.speed = speed;
            return this;
        }

        @Override
        public DefaultTextToSpeechOptions build() {
            return new DefaultTextToSpeechOptions(this.model, this.voice, this.format, this.speed);
        }
    }
}

