/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.util.json.schema;

import java.util.HashMap;
import java.util.Map;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.util.StringUtils;

public final class JsonSchemaUtils {
    private JsonSchemaUtils() {
    }

    public static String ensureValidInputSchema(String inputSchema) {
        if (!StringUtils.hasText((String)inputSchema)) {
            return inputSchema;
        }
        Map<String, Object> schemaMap = ModelOptionsUtils.jsonToMap(inputSchema);
        if (schemaMap == null || schemaMap.isEmpty()) {
            schemaMap = new HashMap<String, Object>();
            schemaMap.put("type", "object");
            schemaMap.put("properties", new HashMap());
            return ModelOptionsUtils.toJsonString(schemaMap);
        }
        if (!schemaMap.containsKey("type")) {
            schemaMap.put("type", "object");
        }
        if ("object".equals(schemaMap.get("type")) && !schemaMap.containsKey("properties")) {
            schemaMap.put("properties", new HashMap());
        }
        return ModelOptionsUtils.toJsonString(schemaMap);
    }
}

