/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.embedding.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import java.util.Optional;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.embedding.EmbeddingResponseMetadata;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationContext;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationDocumentation;
import org.springframework.util.StringUtils;

public class DefaultEmbeddingModelObservationConvention
implements EmbeddingModelObservationConvention {
    public static final String DEFAULT_NAME = "gen_ai.client.operation";
    private static final KeyValue REQUEST_MODEL_NONE = KeyValue.of((KeyName)EmbeddingModelObservationDocumentation.LowCardinalityKeyNames.REQUEST_MODEL, (String)"none");
    private static final KeyValue RESPONSE_MODEL_NONE = KeyValue.of((KeyName)EmbeddingModelObservationDocumentation.LowCardinalityKeyNames.RESPONSE_MODEL, (String)"none");

    public String getName() {
        return DEFAULT_NAME;
    }

    public String getContextualName(EmbeddingModelObservationContext context) {
        return Optional.ofNullable(((EmbeddingRequest)context.getRequest()).getOptions()).map(EmbeddingOptions::getModel).filter(StringUtils::hasText).map(model -> "%s %s".formatted(context.getOperationMetadata().operationType(), model)).orElseGet(() -> context.getOperationMetadata().operationType());
    }

    public KeyValues getLowCardinalityKeyValues(EmbeddingModelObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.aiOperationType(context), this.aiProvider(context), this.requestModel(context), this.responseModel(context)});
    }

    protected KeyValue aiOperationType(EmbeddingModelObservationContext context) {
        return KeyValue.of((KeyName)EmbeddingModelObservationDocumentation.LowCardinalityKeyNames.AI_OPERATION_TYPE, (String)context.getOperationMetadata().operationType());
    }

    protected KeyValue aiProvider(EmbeddingModelObservationContext context) {
        return KeyValue.of((KeyName)EmbeddingModelObservationDocumentation.LowCardinalityKeyNames.AI_PROVIDER, (String)context.getOperationMetadata().provider());
    }

    protected KeyValue requestModel(EmbeddingModelObservationContext context) {
        return Optional.ofNullable(((EmbeddingRequest)context.getRequest()).getOptions()).map(EmbeddingOptions::getModel).filter(StringUtils::hasText).map(model -> KeyValue.of((KeyName)EmbeddingModelObservationDocumentation.LowCardinalityKeyNames.REQUEST_MODEL, (String)model)).orElse(REQUEST_MODEL_NONE);
    }

    protected KeyValue responseModel(EmbeddingModelObservationContext context) {
        return Optional.ofNullable((EmbeddingResponse)context.getResponse()).map(EmbeddingResponse::getMetadata).map(EmbeddingResponseMetadata::getModel).filter(StringUtils::hasText).map(model -> KeyValue.of((KeyName)EmbeddingModelObservationDocumentation.LowCardinalityKeyNames.RESPONSE_MODEL, (String)model)).orElse(RESPONSE_MODEL_NONE);
    }

    public KeyValues getHighCardinalityKeyValues(EmbeddingModelObservationContext context) {
        KeyValues keyValues = KeyValues.empty();
        keyValues = this.requestEmbeddingDimension(keyValues, context);
        keyValues = this.usageInputTokens(keyValues, context);
        keyValues = this.usageTotalTokens(keyValues, context);
        return keyValues;
    }

    protected KeyValues requestEmbeddingDimension(KeyValues keyValues, EmbeddingModelObservationContext context) {
        return Optional.ofNullable(((EmbeddingRequest)context.getRequest()).getOptions()).map(EmbeddingOptions::getDimensions).map(dimensions -> keyValues.and(EmbeddingModelObservationDocumentation.HighCardinalityKeyNames.REQUEST_EMBEDDING_DIMENSIONS.asString(), String.valueOf(dimensions))).orElse(keyValues);
    }

    protected KeyValues usageInputTokens(KeyValues keyValues, EmbeddingModelObservationContext context) {
        return Optional.ofNullable((EmbeddingResponse)context.getResponse()).map(EmbeddingResponse::getMetadata).map(EmbeddingResponseMetadata::getUsage).map(Usage::getPromptTokens).map(promptTokens -> keyValues.and(EmbeddingModelObservationDocumentation.HighCardinalityKeyNames.USAGE_INPUT_TOKENS.asString(), String.valueOf(promptTokens))).orElse(keyValues);
    }

    protected KeyValues usageTotalTokens(KeyValues keyValues, EmbeddingModelObservationContext context) {
        return Optional.ofNullable((EmbeddingResponse)context.getResponse()).map(EmbeddingResponse::getMetadata).map(EmbeddingResponseMetadata::getUsage).map(Usage::getTotalTokens).map(totalTokens -> keyValues.and(EmbeddingModelObservationDocumentation.HighCardinalityKeyNames.USAGE_TOTAL_TOKENS.asString(), String.valueOf(totalTokens))).orElse(keyValues);
    }
}

