/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.image.observation;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import java.util.Collection;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.image.ImagePrompt;
import org.springframework.ai.image.observation.ImageModelObservationContext;
import org.springframework.util.CollectionUtils;

public class ImageModelPromptContentObservationHandler
implements ObservationHandler<ImageModelObservationContext> {
    private static final Logger logger = LoggerFactory.getLogger(ImageModelPromptContentObservationHandler.class);

    public void onStop(ImageModelObservationContext context) {
        if (!CollectionUtils.isEmpty((Collection)((ImagePrompt)context.getRequest()).getInstructions())) {
            StringJoiner promptMessagesJoiner = new StringJoiner(", ", "[", "]");
            ((ImagePrompt)context.getRequest()).getInstructions().forEach(message -> promptMessagesJoiner.add("\"" + message.getText() + "\""));
            logger.info("Image Model Prompt Content:\n{}", (Object)promptMessagesJoiner);
        }
    }

    public boolean supportsContext(Observation.Context context) {
        return context instanceof ImageModelObservationContext;
    }
}

