/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.observation;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.observation.ObservabilityHelper;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ChatModelCompletionObservationHandler
implements ObservationHandler<ChatModelObservationContext> {
    private static final Logger logger = LoggerFactory.getLogger(ChatModelCompletionObservationHandler.class);

    public void onStop(ChatModelObservationContext context) {
        logger.debug("Chat Model Completion:\n{}", (Object)ObservabilityHelper.concatenateStrings(this.completion(context)));
    }

    private List<String> completion(ChatModelObservationContext context) {
        if (context.getResponse() == null || ((ChatResponse)context.getResponse()).getResults() == null || CollectionUtils.isEmpty(((ChatResponse)context.getResponse()).getResults())) {
            return List.of();
        }
        if (!StringUtils.hasText((String)((ChatResponse)context.getResponse()).getResult().getOutput().getText())) {
            return List.of();
        }
        return ((ChatResponse)context.getResponse()).getResults().stream().filter(generation -> generation.getOutput() != null && StringUtils.hasText((String)generation.getOutput().getText())).map(generation -> generation.getOutput().getText()).toList();
    }

    public boolean supportsContext(Observation.Context context) {
        return context instanceof ChatModelObservationContext;
    }
}

