/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mistralai.ocr;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.springframework.ai.mistralai.ocr.MistralOcrApi;
import org.springframework.ai.model.ModelOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MistralAiOcrOptions
implements ModelOptions {
    @JsonProperty(value="model")
    private String model = MistralOcrApi.OCRModel.MISTRAL_OCR_LATEST.getValue();
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="pages")
    private List<Integer> pages;
    @JsonProperty(value="include_image_base64")
    private Boolean includeImageBase64;
    @JsonProperty(value="image_limit")
    private Integer imageLimit;
    @JsonProperty(value="image_min_size")
    private Integer imageMinSize;

    public static Builder builder() {
        return new Builder();
    }

    public String getModel() {
        return this.model;
    }

    public String getId() {
        return this.id;
    }

    public List<Integer> getPages() {
        return this.pages;
    }

    public Boolean getIncludeImageBase64() {
        return this.includeImageBase64;
    }

    public Integer getImageLimit() {
        return this.imageLimit;
    }

    public Integer getImageMinSize() {
        return this.imageMinSize;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPages(List<Integer> pages) {
        this.pages = pages;
    }

    public void setIncludeImageBase64(Boolean includeImageBase64) {
        this.includeImageBase64 = includeImageBase64;
    }

    public void setImageLimit(Integer imageLimit) {
        this.imageLimit = imageLimit;
    }

    public void setImageMinSize(Integer imageMinSize) {
        this.imageMinSize = imageMinSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MistralAiOcrOptions that = (MistralAiOcrOptions)o;
        return Objects.equals(this.model, that.model) && Objects.equals(this.id, that.id) && Objects.equals(this.pages, that.pages) && Objects.equals(this.includeImageBase64, that.includeImageBase64) && Objects.equals(this.imageLimit, that.imageLimit) && Objects.equals(this.imageMinSize, that.imageMinSize);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.id, this.pages, this.includeImageBase64, this.imageLimit, this.imageMinSize);
    }

    public static final class Builder {
        private final MistralAiOcrOptions options = new MistralAiOcrOptions();

        private Builder() {
        }

        public Builder model(String model) {
            this.options.setModel(model);
            return this;
        }

        public Builder id(String id) {
            this.options.setId(id);
            return this;
        }

        public Builder pages(List<Integer> pages) {
            this.options.setPages(pages);
            return this;
        }

        public Builder includeImageBase64(Boolean includeImageBase64) {
            this.options.setIncludeImageBase64(includeImageBase64);
            return this;
        }

        public Builder imageLimit(Integer imageLimit) {
            this.options.setImageLimit(imageLimit);
            return this;
        }

        public Builder imageMinSize(Integer imageMinSize) {
            this.options.setImageMinSize(imageMinSize);
            return this;
        }

        public MistralAiOcrOptions build() {
            return this.options;
        }
    }
}

