/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.minimax.api;

import java.util.ArrayList;
import java.util.List;
import org.springframework.ai.minimax.api.MiniMaxApi;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MiniMaxStreamFunctionCallingHelper {
    public MiniMaxApi.ChatCompletionChunk merge(MiniMaxApi.ChatCompletionChunk previous, MiniMaxApi.ChatCompletionChunk current) {
        if (previous == null) {
            return current;
        }
        String id = current.id() != null ? current.id() : previous.id();
        Long created = current.created() != null ? current.created() : previous.created();
        String model = current.model() != null ? current.model() : previous.model();
        String systemFingerprint = current.systemFingerprint() != null ? current.systemFingerprint() : previous.systemFingerprint();
        String object = current.object() != null ? current.object() : previous.object();
        MiniMaxApi.ChatCompletionChunk.ChunkChoice previousChoice0 = CollectionUtils.isEmpty(previous.choices()) ? null : previous.choices().get(0);
        MiniMaxApi.ChatCompletionChunk.ChunkChoice currentChoice0 = CollectionUtils.isEmpty(current.choices()) ? null : current.choices().get(0);
        MiniMaxApi.ChatCompletionChunk.ChunkChoice choice = this.merge(previousChoice0, currentChoice0);
        List<MiniMaxApi.ChatCompletionChunk.ChunkChoice> chunkChoices = choice == null ? List.of() : List.of(choice);
        return new MiniMaxApi.ChatCompletionChunk(id, chunkChoices, created, model, systemFingerprint, object);
    }

    private MiniMaxApi.ChatCompletionChunk.ChunkChoice merge(MiniMaxApi.ChatCompletionChunk.ChunkChoice previous, MiniMaxApi.ChatCompletionChunk.ChunkChoice current) {
        if (previous == null) {
            return current;
        }
        MiniMaxApi.ChatCompletionFinishReason finishReason = current.finishReason() != null ? current.finishReason() : previous.finishReason();
        Integer index = current.index() != null ? current.index() : previous.index();
        MiniMaxApi.LogProbs logprobs = current.logprobs() != null ? current.logprobs() : previous.logprobs();
        MiniMaxApi.ChatCompletionMessage message = this.merge(previous.delta(), current.delta());
        return new MiniMaxApi.ChatCompletionChunk.ChunkChoice(finishReason, index, message, logprobs);
    }

    private MiniMaxApi.ChatCompletionMessage merge(MiniMaxApi.ChatCompletionMessage previous, MiniMaxApi.ChatCompletionMessage current) {
        String content = current.content() != null ? current.content() : (previous.content() != null ? previous.content() : "");
        MiniMaxApi.ChatCompletionMessage.Role role = current.role() != null ? current.role() : previous.role();
        role = role != null ? role : MiniMaxApi.ChatCompletionMessage.Role.ASSISTANT;
        String name = current.name() != null ? current.name() : previous.name();
        String toolCallId = current.toolCallId() != null ? current.toolCallId() : previous.toolCallId();
        ArrayList<MiniMaxApi.ChatCompletionMessage.ToolCall> toolCalls = new ArrayList<MiniMaxApi.ChatCompletionMessage.ToolCall>();
        MiniMaxApi.ChatCompletionMessage.ToolCall lastPreviousTooCall = null;
        if (previous.toolCalls() != null) {
            lastPreviousTooCall = previous.toolCalls().get(previous.toolCalls().size() - 1);
            if (previous.toolCalls().size() > 1) {
                toolCalls.addAll(previous.toolCalls().subList(0, previous.toolCalls().size() - 1));
            }
        }
        if (current.toolCalls() != null) {
            if (current.toolCalls().size() > 1) {
                throw new IllegalStateException("Currently only one tool call is supported per message!");
            }
            MiniMaxApi.ChatCompletionMessage.ToolCall currentToolCall = current.toolCalls().iterator().next();
            if (currentToolCall.id() == null || lastPreviousTooCall != null && currentToolCall.id().equals(lastPreviousTooCall.id())) {
                toolCalls.add(this.merge(lastPreviousTooCall, currentToolCall));
            } else {
                if (lastPreviousTooCall != null) {
                    toolCalls.add(lastPreviousTooCall);
                }
                toolCalls.add(currentToolCall);
            }
        } else if (lastPreviousTooCall != null) {
            toolCalls.add(lastPreviousTooCall);
        }
        return new MiniMaxApi.ChatCompletionMessage(content, role, name, toolCallId, toolCalls);
    }

    private MiniMaxApi.ChatCompletionMessage.ToolCall merge(MiniMaxApi.ChatCompletionMessage.ToolCall previous, MiniMaxApi.ChatCompletionMessage.ToolCall current) {
        if (previous == null) {
            return current;
        }
        String id = current.id() != null ? current.id() : previous.id();
        String type = current.type() != null ? current.type() : previous.type();
        MiniMaxApi.ChatCompletionMessage.ChatCompletionFunction function = this.merge(previous.function(), current.function());
        return new MiniMaxApi.ChatCompletionMessage.ToolCall(id, type, function);
    }

    private MiniMaxApi.ChatCompletionMessage.ChatCompletionFunction merge(MiniMaxApi.ChatCompletionMessage.ChatCompletionFunction previous, MiniMaxApi.ChatCompletionMessage.ChatCompletionFunction current) {
        if (previous == null) {
            return current;
        }
        String name = StringUtils.hasLength((String)current.name()) ? current.name() : previous.name();
        StringBuilder arguments = new StringBuilder();
        if (previous.arguments() != null) {
            arguments.append(previous.arguments());
        }
        if (current.arguments() != null) {
            arguments.append(current.arguments());
        }
        return new MiniMaxApi.ChatCompletionMessage.ChatCompletionFunction(name, arguments.toString());
    }

    public boolean isStreamingToolFunctionCall(MiniMaxApi.ChatCompletionChunk chatCompletion) {
        if (chatCompletion == null || CollectionUtils.isEmpty(chatCompletion.choices())) {
            return false;
        }
        MiniMaxApi.ChatCompletionChunk.ChunkChoice choice = chatCompletion.choices().get(0);
        if (choice == null || choice.delta() == null) {
            return false;
        }
        return !CollectionUtils.isEmpty(choice.delta().toolCalls());
    }

    public boolean isStreamingToolFunctionCallFinish(MiniMaxApi.ChatCompletionChunk chatCompletion) {
        if (chatCompletion == null || CollectionUtils.isEmpty(chatCompletion.choices())) {
            return false;
        }
        MiniMaxApi.ChatCompletionChunk.ChunkChoice choice = chatCompletion.choices().get(0);
        if (choice == null || choice.delta() == null) {
            return false;
        }
        return choice.finishReason() == MiniMaxApi.ChatCompletionFinishReason.TOOL_CALLS;
    }

    public MiniMaxApi.ChatCompletion chunkToChatCompletion(MiniMaxApi.ChatCompletionChunk chunk) {
        List<MiniMaxApi.ChatCompletion.Choice> choices = chunk.choices().stream().map(chunkChoice -> new MiniMaxApi.ChatCompletion.Choice(chunkChoice.finishReason(), chunkChoice.index(), chunkChoice.delta(), null, chunkChoice.logprobs())).toList();
        return new MiniMaxApi.ChatCompletion(chunk.id(), choices, chunk.created(), chunk.model(), chunk.systemFingerprint(), "chat.completion", null, null);
    }
}

