/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp;

import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.Map;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.definition.ToolDefinition;

public class SyncMcpToolCallback
implements ToolCallback {
    private final McpSyncClient mcpClient;
    private final McpSchema.Tool tool;

    public SyncMcpToolCallback(McpSyncClient mcpClient, McpSchema.Tool tool) {
        this.mcpClient = mcpClient;
        this.tool = tool;
    }

    public ToolDefinition getToolDefinition() {
        return ToolDefinition.builder().name(this.tool.name()).description(this.tool.description()).inputSchema(ModelOptionsUtils.toJsonString((Object)this.tool.inputSchema())).build();
    }

    public String call(String functionInput) {
        Map arguments = ModelOptionsUtils.jsonToMap((String)functionInput);
        McpSchema.CallToolResult response = this.mcpClient.callTool(new McpSchema.CallToolRequest(this.getToolDefinition().name(), arguments));
        return ModelOptionsUtils.toJsonString((Object)response.content());
    }
}

