/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp;

import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.List;
import org.springframework.ai.mcp.AsyncMcpToolCallbackProvider;
import org.springframework.ai.mcp.SyncMcpToolCallbackProvider;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public final class McpToolUtils {
    private McpToolUtils() {
    }

    public static List<McpServerFeatures.SyncToolRegistration> toSyncToolRegistration(List<ToolCallback> toolCallbacks) {
        return toolCallbacks.stream().map(McpToolUtils::toSyncToolRegistration).toList();
    }

    public static List<McpServerFeatures.SyncToolRegistration> toSyncToolRegistration(ToolCallback ... toolCallbacks) {
        return McpToolUtils.toSyncToolRegistration(List.of(toolCallbacks));
    }

    public static McpServerFeatures.SyncToolRegistration toSyncToolRegistration(ToolCallback toolCallback) {
        McpSchema.Tool tool = new McpSchema.Tool(toolCallback.getToolDefinition().name(), toolCallback.getToolDefinition().description(), toolCallback.getToolDefinition().inputSchema());
        return new McpServerFeatures.SyncToolRegistration(tool, request -> {
            try {
                String callResult = toolCallback.call(ModelOptionsUtils.toJsonString((Object)request));
                return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(callResult)), Boolean.valueOf(false));
            }
            catch (Exception e) {
                return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(e.getMessage())), Boolean.valueOf(true));
            }
        });
    }

    public static List<McpServerFeatures.AsyncToolRegistration> toAsyncToolRegistration(List<ToolCallback> toolCallbacks) {
        return toolCallbacks.stream().map(McpToolUtils::toAsyncToolRegistration).toList();
    }

    public static List<McpServerFeatures.AsyncToolRegistration> toAsyncToolRegistration(ToolCallback ... toolCallbacks) {
        return McpToolUtils.toAsyncToolRegistration(List.of(toolCallbacks));
    }

    public static McpServerFeatures.AsyncToolRegistration toAsyncToolRegistration(ToolCallback toolCallback) {
        McpServerFeatures.SyncToolRegistration syncToolRegistration = McpToolUtils.toSyncToolRegistration(toolCallback);
        return new McpServerFeatures.AsyncToolRegistration(syncToolRegistration.tool(), map -> Mono.fromCallable(() -> (McpSchema.CallToolResult)syncToolRegistration.call().apply(map)).subscribeOn(Schedulers.boundedElastic()));
    }

    public static List<ToolCallback> getToolCallbacksFromSyncClients(McpSyncClient ... mcpClients) {
        return McpToolUtils.getToolCallbacksFromSyncClients(List.of(mcpClients));
    }

    public static List<ToolCallback> getToolCallbacksFromSyncClients(List<McpSyncClient> mcpClients) {
        if (CollectionUtils.isEmpty(mcpClients)) {
            return List.of();
        }
        return List.of(new SyncMcpToolCallbackProvider(mcpClients).getToolCallbacks());
    }

    public static List<ToolCallback> getToolCallbacksFromAsyncClients(McpAsyncClient ... asynMcpClients) {
        return McpToolUtils.getToolCallbacksFromAsyncClinents(List.of(asynMcpClients));
    }

    public static List<ToolCallback> getToolCallbacksFromAsyncClinents(List<McpAsyncClient> asynMcpClients) {
        if (CollectionUtils.isEmpty(asynMcpClients)) {
            return List.of();
        }
        return List.of(new AsyncMcpToolCallbackProvider(asynMcpClients).getToolCallbacks());
    }
}

