/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp;

import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.util.ArrayList;
import java.util.List;
import org.springframework.ai.mcp.AsyncMcpToolCallback;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.ai.tool.util.ToolUtils;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;

public class AsyncMcpToolCallbackProvider
implements ToolCallbackProvider {
    private final List<McpAsyncClient> mcpClients;

    public AsyncMcpToolCallbackProvider(List<McpAsyncClient> mcpClients) {
        Assert.notNull(mcpClients, (String)"McpClients must not be null");
        this.mcpClients = mcpClients;
    }

    public AsyncMcpToolCallbackProvider(McpAsyncClient ... mcpClients) {
        Assert.notNull((Object)mcpClients, (String)"McpClients must not be null");
        this.mcpClients = List.of(mcpClients);
    }

    public ToolCallback[] getToolCallbacks() {
        ArrayList<ToolCallback> toolCallbackList = new ArrayList<ToolCallback>();
        for (McpAsyncClient mcpClient : this.mcpClients) {
            ToolCallback[] toolCallbacks = (ToolCallback[])mcpClient.listTools().map(response -> (ToolCallback[])response.tools().stream().map(tool -> new AsyncMcpToolCallback(mcpClient, (McpSchema.Tool)tool)).toArray(ToolCallback[]::new)).block();
            this.validateToolCallbacks(toolCallbacks);
            toolCallbackList.addAll(List.of(toolCallbacks));
        }
        return toolCallbackList.toArray(new ToolCallback[0]);
    }

    private void validateToolCallbacks(ToolCallback[] toolCallbacks) {
        List duplicateToolNames = ToolUtils.getDuplicateToolNames((FunctionCallback[])toolCallbacks);
        if (!duplicateToolNames.isEmpty()) {
            throw new IllegalStateException("Multiple tools with the same name (%s)".formatted(String.join((CharSequence)", ", duplicateToolNames)));
        }
    }

    public static Flux<ToolCallback> asyncToolCallbacks(List<McpAsyncClient> mcpClients) {
        if (CollectionUtils.isEmpty(mcpClients)) {
            return Flux.empty();
        }
        return Flux.fromArray((Object[])new AsyncMcpToolCallbackProvider(mcpClients).getToolCallbacks());
    }
}

