/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.google.genai.cache;

import com.google.genai.AsyncCaches;
import com.google.genai.Caches;
import com.google.genai.Client;
import com.google.genai.Pager;
import com.google.genai.types.CachedContent;
import com.google.genai.types.CreateCachedContentConfig;
import com.google.genai.types.DeleteCachedContentConfig;
import com.google.genai.types.DeleteCachedContentResponse;
import com.google.genai.types.GetCachedContentConfig;
import com.google.genai.types.ListCachedContentsConfig;
import com.google.genai.types.UpdateCachedContentConfig;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.google.genai.cache.CachedContentRequest;
import org.springframework.ai.google.genai.cache.CachedContentUpdateRequest;
import org.springframework.ai.google.genai.cache.GoogleGenAiCachedContent;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class GoogleGenAiCachedContentService {
    private static final Logger logger = LoggerFactory.getLogger(GoogleGenAiCachedContentService.class);
    private final Client genAiClient;
    private final Caches caches;
    private final AsyncCaches asyncCaches;

    public GoogleGenAiCachedContentService(Client genAiClient) {
        Assert.notNull((Object)genAiClient, (String)"GenAI client must not be null");
        this.genAiClient = genAiClient;
        this.caches = genAiClient.caches;
        this.asyncCaches = genAiClient.async.caches;
    }

    public GoogleGenAiCachedContent create(CachedContentRequest request) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        CreateCachedContentConfig.Builder configBuilder = CreateCachedContentConfig.builder().contents(request.getContents());
        if (request.getSystemInstruction() != null) {
            configBuilder.systemInstruction(request.getSystemInstruction());
        }
        if (request.getDisplayName() != null) {
            configBuilder.displayName(request.getDisplayName());
        }
        if (request.getTtl() != null) {
            configBuilder.ttl(request.getTtl());
        } else if (request.getExpireTime() != null) {
            configBuilder.expireTime(request.getExpireTime());
        }
        try {
            CreateCachedContentConfig config = configBuilder.build();
            CachedContent cachedContent = this.caches.create(request.getModel(), config);
            logger.debug("Created cached content: {}", (Object)cachedContent.name().orElse("unknown"));
            return GoogleGenAiCachedContent.from(cachedContent);
        }
        catch (Exception e) {
            logger.error("Failed to create cached content", (Throwable)e);
            throw new CachedContentException("Failed to create cached content", e);
        }
    }

    @Nullable
    public GoogleGenAiCachedContent get(String name) {
        Assert.hasText((String)name, (String)"Name must not be empty");
        try {
            GetCachedContentConfig config = GetCachedContentConfig.builder().build();
            CachedContent cachedContent = this.caches.get(name, config);
            logger.debug("Retrieved cached content: {}", (Object)name);
            return GoogleGenAiCachedContent.from(cachedContent);
        }
        catch (Exception e) {
            logger.error("Failed to get cached content: {}", (Object)name, (Object)e);
            return null;
        }
    }

    public GoogleGenAiCachedContent update(String name, CachedContentUpdateRequest request) {
        Assert.hasText((String)name, (String)"Name must not be empty");
        Assert.notNull((Object)request, (String)"Request must not be null");
        UpdateCachedContentConfig.Builder configBuilder = UpdateCachedContentConfig.builder();
        if (request.getTtl() != null) {
            configBuilder.ttl(request.getTtl());
        }
        if (request.getExpireTime() != null) {
            configBuilder.expireTime(request.getExpireTime());
        }
        try {
            UpdateCachedContentConfig config = configBuilder.build();
            CachedContent cachedContent = this.caches.update(name, config);
            logger.debug("Updated cached content: {}", (Object)name);
            return GoogleGenAiCachedContent.from(cachedContent);
        }
        catch (Exception e) {
            logger.error("Failed to update cached content: {}", (Object)name, (Object)e);
            throw new CachedContentException("Failed to update cached content: " + name, e);
        }
    }

    public boolean delete(String name) {
        Assert.hasText((String)name, (String)"Name must not be empty");
        try {
            DeleteCachedContentConfig config = DeleteCachedContentConfig.builder().build();
            DeleteCachedContentResponse response = this.caches.delete(name, config);
            logger.debug("Deleted cached content: {}", (Object)name);
            return true;
        }
        catch (Exception e) {
            logger.error("Failed to delete cached content: {}", (Object)name, (Object)e);
            return false;
        }
    }

    public CachedContentPage list(@Nullable Integer pageSize, @Nullable String pageToken) {
        ListCachedContentsConfig.Builder configBuilder = ListCachedContentsConfig.builder();
        if (pageSize != null && pageSize > 0) {
            configBuilder.pageSize(pageSize);
        }
        if (pageToken != null) {
            configBuilder.pageToken(pageToken);
        }
        try {
            ListCachedContentsConfig config = configBuilder.build();
            Pager pager = this.caches.list(config);
            ArrayList<GoogleGenAiCachedContent> contents = new ArrayList<GoogleGenAiCachedContent>();
            for (CachedContent content : pager) {
                contents.add(GoogleGenAiCachedContent.from(content));
                if (contents.size() < (pageSize != null ? pageSize : 100)) continue;
                break;
            }
            logger.debug("Listed {} cached content items", (Object)contents.size());
            return new CachedContentPage(contents, null);
        }
        catch (Exception e) {
            logger.error("Failed to list cached content", (Throwable)e);
            throw new CachedContentException("Failed to list cached content", e);
        }
    }

    public List<GoogleGenAiCachedContent> listAll() {
        CachedContentPage page;
        ArrayList<GoogleGenAiCachedContent> allContent = new ArrayList<GoogleGenAiCachedContent>();
        String pageToken = null;
        do {
            page = this.list(100, pageToken);
            allContent.addAll(page.getContents());
        } while ((pageToken = page.getNextPageToken()) != null);
        return allContent;
    }

    public CompletableFuture<GoogleGenAiCachedContent> createAsync(CachedContentRequest request) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        CreateCachedContentConfig.Builder configBuilder = CreateCachedContentConfig.builder().contents(request.getContents());
        if (request.getSystemInstruction() != null) {
            configBuilder.systemInstruction(request.getSystemInstruction());
        }
        if (request.getDisplayName() != null) {
            configBuilder.displayName(request.getDisplayName());
        }
        if (request.getTtl() != null) {
            configBuilder.ttl(request.getTtl());
        } else if (request.getExpireTime() != null) {
            configBuilder.expireTime(request.getExpireTime());
        }
        try {
            CreateCachedContentConfig config = configBuilder.build();
            return this.asyncCaches.create(request.getModel(), config).thenApply(GoogleGenAiCachedContent::from);
        }
        catch (Exception e) {
            logger.error("Failed to create cached content asynchronously", (Throwable)e);
            return CompletableFuture.failedFuture(new CachedContentException("Failed to create cached content", e));
        }
    }

    public CompletableFuture<GoogleGenAiCachedContent> getAsync(String name) {
        Assert.hasText((String)name, (String)"Name must not be empty");
        try {
            GetCachedContentConfig config = GetCachedContentConfig.builder().build();
            return this.asyncCaches.get(name, config).thenApply(GoogleGenAiCachedContent::from);
        }
        catch (Exception e) {
            logger.error("Failed to get cached content asynchronously: {}", (Object)name, (Object)e);
            return CompletableFuture.failedFuture(new CachedContentException("Failed to get cached content", e));
        }
    }

    public CompletableFuture<GoogleGenAiCachedContent> updateAsync(String name, CachedContentUpdateRequest request) {
        Assert.hasText((String)name, (String)"Name must not be empty");
        Assert.notNull((Object)request, (String)"Request must not be null");
        UpdateCachedContentConfig.Builder configBuilder = UpdateCachedContentConfig.builder();
        if (request.getTtl() != null) {
            configBuilder.ttl(request.getTtl());
        }
        if (request.getExpireTime() != null) {
            configBuilder.expireTime(request.getExpireTime());
        }
        try {
            UpdateCachedContentConfig config = configBuilder.build();
            return this.asyncCaches.update(name, config).thenApply(GoogleGenAiCachedContent::from);
        }
        catch (Exception e) {
            logger.error("Failed to update cached content asynchronously: {}", (Object)name, (Object)e);
            return CompletableFuture.failedFuture(new CachedContentException("Failed to update cached content", e));
        }
    }

    public CompletableFuture<Boolean> deleteAsync(String name) {
        Assert.hasText((String)name, (String)"Name must not be empty");
        try {
            DeleteCachedContentConfig config = DeleteCachedContentConfig.builder().build();
            return ((CompletableFuture)this.asyncCaches.delete(name, config).thenApply(response -> true)).exceptionally(e -> {
                logger.error("Failed to delete cached content asynchronously: {}", (Object)name, e);
                return false;
            });
        }
        catch (Exception e2) {
            logger.error("Failed to delete cached content asynchronously: {}", (Object)name, (Object)e2);
            return CompletableFuture.completedFuture(false);
        }
    }

    public GoogleGenAiCachedContent extendTtl(String name, Duration additionalTtl) {
        Assert.hasText((String)name, (String)"Name must not be empty");
        Assert.notNull((Object)additionalTtl, (String)"Additional TTL must not be null");
        GoogleGenAiCachedContent existing = this.get(name);
        if (existing == null) {
            throw new CachedContentException("Cached content not found: " + name);
        }
        Instant newExpireTime = existing.getExpireTime() != null ? existing.getExpireTime().plus(additionalTtl) : Instant.now().plus(additionalTtl);
        CachedContentUpdateRequest updateRequest = CachedContentUpdateRequest.builder().expireTime(newExpireTime).build();
        return this.update(name, updateRequest);
    }

    public GoogleGenAiCachedContent refreshExpiration(String name, Duration maxTtl) {
        Assert.hasText((String)name, (String)"Name must not be empty");
        Assert.notNull((Object)maxTtl, (String)"Max TTL must not be null");
        CachedContentUpdateRequest updateRequest = CachedContentUpdateRequest.builder().ttl(maxTtl).build();
        return this.update(name, updateRequest);
    }

    public int cleanupExpired() {
        List<GoogleGenAiCachedContent> allContent = this.listAll();
        int removed = 0;
        for (GoogleGenAiCachedContent content : allContent) {
            if (!content.isExpired() || !this.delete(content.getName())) continue;
            ++removed;
            logger.info("Removed expired cached content: {}", (Object)content.getName());
        }
        return removed;
    }

    public static class CachedContentException
    extends RuntimeException {
        public CachedContentException(String message) {
            super(message);
        }

        public CachedContentException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class CachedContentPage {
        private final List<GoogleGenAiCachedContent> contents;
        private final String nextPageToken;

        public CachedContentPage(List<GoogleGenAiCachedContent> contents, String nextPageToken) {
            this.contents = contents != null ? new ArrayList<GoogleGenAiCachedContent>(contents) : new ArrayList();
            this.nextPageToken = nextPageToken;
        }

        public List<GoogleGenAiCachedContent> getContents() {
            return this.contents;
        }

        public String getNextPageToken() {
            return this.nextPageToken;
        }

        public boolean hasNextPage() {
            return this.nextPageToken != null;
        }
    }
}

