/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.evaluation;

import java.util.Collections;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.evaluation.EvaluationRequest;
import org.springframework.ai.evaluation.EvaluationResponse;
import org.springframework.ai.evaluation.Evaluator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class FactCheckingEvaluator
implements Evaluator {
    private static final String DEFAULT_EVALUATION_PROMPT_TEXT = "\tEvaluate whether or not the following claim is supported by the provided document.\n\tRespond with \"yes\" if the claim is supported, or \"no\" if it is not.\n\n\tDocument:\n\t{document}\n\n\tClaim:\n\t{claim}\n";
    private static final String BESPOKE_EVALUATION_PROMPT_TEXT = "\tDocument:\n\t{document}\n\n\tClaim:\n\t{claim}\n";
    private final ChatClient.Builder chatClientBuilder;
    private final String evaluationPrompt;

    protected FactCheckingEvaluator(ChatClient.Builder chatClientBuilder, @Nullable String evaluationPrompt) {
        Assert.notNull((Object)chatClientBuilder, (String)"chatClientBuilder cannot be null");
        this.chatClientBuilder = chatClientBuilder;
        this.evaluationPrompt = evaluationPrompt != null ? evaluationPrompt : DEFAULT_EVALUATION_PROMPT_TEXT;
    }

    public static FactCheckingEvaluator forBespokeMinicheck(ChatClient.Builder chatClientBuilder) {
        return FactCheckingEvaluator.builder(chatClientBuilder).evaluationPrompt(BESPOKE_EVALUATION_PROMPT_TEXT).build();
    }

    public EvaluationResponse evaluate(EvaluationRequest evaluationRequest) {
        String response = evaluationRequest.getResponseContent();
        String context = this.doGetSupportingData(evaluationRequest);
        String evaluationResponse = this.chatClientBuilder.build().prompt().user(userSpec -> userSpec.text(this.evaluationPrompt).param("document", context).param("claim", response)).call().content();
        boolean passing = "yes".equalsIgnoreCase(evaluationResponse);
        return new EvaluationResponse(passing, "", Collections.emptyMap());
    }

    public static Builder builder(ChatClient.Builder chatClientBuilder) {
        return new Builder().chatClientBuilder(chatClientBuilder);
    }

    public static final class Builder {
        private ChatClient.Builder chatClientBuilder;
        private String evaluationPrompt;

        private Builder() {
        }

        public Builder chatClientBuilder(ChatClient.Builder chatClientBuilder) {
            this.chatClientBuilder = chatClientBuilder;
            return this;
        }

        public Builder evaluationPrompt(String evaluationPrompt) {
            this.evaluationPrompt = evaluationPrompt;
            return this;
        }

        public FactCheckingEvaluator build() {
            return new FactCheckingEvaluator(this.chatClientBuilder, this.evaluationPrompt);
        }
    }
}

