/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.advisor;

import java.util.Map;
import org.springframework.ai.chat.client.ChatClientAttributes;
import org.springframework.ai.chat.client.ChatClientRequest;
import org.springframework.ai.chat.client.ChatClientResponse;
import org.springframework.ai.chat.client.advisor.api.CallAdvisor;
import org.springframework.ai.chat.client.advisor.api.CallAdvisorChain;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.tool.StructuredOutputChatOptions;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class ChatModelCallAdvisor
implements CallAdvisor {
    private final ChatModel chatModel;

    private ChatModelCallAdvisor(ChatModel chatModel) {
        Assert.notNull((Object)chatModel, (String)"chatModel cannot be null");
        this.chatModel = chatModel;
    }

    @Override
    public ChatClientResponse adviseCall(ChatClientRequest chatClientRequest, CallAdvisorChain callAdvisorChain) {
        Assert.notNull((Object)chatClientRequest, (String)"the chatClientRequest cannot be null");
        ChatClientRequest formattedChatClientRequest = ChatModelCallAdvisor.augmentWithFormatInstructions(chatClientRequest);
        ChatResponse chatResponse = this.chatModel.call(formattedChatClientRequest.prompt());
        return ChatClientResponse.builder().chatResponse(chatResponse).context(Map.copyOf(formattedChatClientRequest.context())).build();
    }

    private static ChatClientRequest augmentWithFormatInstructions(ChatClientRequest chatClientRequest) {
        ChatOptions chatOptions;
        String outputFormat = (String)chatClientRequest.context().get(ChatClientAttributes.OUTPUT_FORMAT.getKey());
        String outputSchema = (String)chatClientRequest.context().get(ChatClientAttributes.STRUCTURED_OUTPUT_SCHEMA.getKey());
        if (!StringUtils.hasText((String)outputFormat) && !StringUtils.hasText((String)outputSchema)) {
            return chatClientRequest;
        }
        if (chatClientRequest.context().containsKey(ChatClientAttributes.STRUCTURED_OUTPUT_NATIVE.getKey()) && StringUtils.hasText((String)outputSchema) && (chatOptions = chatClientRequest.prompt().getOptions()) instanceof StructuredOutputChatOptions) {
            StructuredOutputChatOptions structuredOutputChatOptions = (StructuredOutputChatOptions)chatOptions;
            structuredOutputChatOptions.setOutputSchema(outputSchema);
            return chatClientRequest;
        }
        Prompt augmentedPrompt = chatClientRequest.prompt().augmentUserMessage(userMessage -> userMessage.mutate().text(userMessage.getText() + System.lineSeparator() + outputFormat).build());
        return ChatClientRequest.builder().prompt(augmentedPrompt).context(Map.copyOf(chatClientRequest.context())).build();
    }

    @Override
    public String getName() {
        return "call";
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ChatModel chatModel;

        private Builder() {
        }

        public Builder chatModel(ChatModel chatModel) {
            this.chatModel = chatModel;
            return this;
        }

        public ChatModelCallAdvisor build() {
            return new ChatModelCallAdvisor(this.chatModel);
        }
    }
}

