/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.advisor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClientMessageAggregator;
import org.springframework.ai.chat.client.ChatClientRequest;
import org.springframework.ai.chat.client.ChatClientResponse;
import org.springframework.ai.chat.client.advisor.api.AdvisorChain;
import org.springframework.ai.chat.client.advisor.api.BaseAdvisor;
import org.springframework.ai.chat.client.advisor.api.BaseChatMemoryAdvisor;
import org.springframework.ai.chat.client.advisor.api.StreamAdvisorChain;
import org.springframework.ai.chat.memory.ChatMemory;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

public final class PromptChatMemoryAdvisor
implements BaseChatMemoryAdvisor {
    private static final Logger logger = LoggerFactory.getLogger(PromptChatMemoryAdvisor.class);
    private static final PromptTemplate DEFAULT_SYSTEM_PROMPT_TEMPLATE = new PromptTemplate("{instructions}\n\nUse the conversation memory from the MEMORY section to provide accurate answers.\n\n---------------------\nMEMORY:\n{memory}\n---------------------\n\n");
    private final PromptTemplate systemPromptTemplate;
    private final String defaultConversationId;
    private final int order;
    private final Scheduler scheduler;
    private final ChatMemory chatMemory;

    private PromptChatMemoryAdvisor(ChatMemory chatMemory, String defaultConversationId, int order, Scheduler scheduler, PromptTemplate systemPromptTemplate) {
        Assert.notNull((Object)chatMemory, (String)"chatMemory cannot be null");
        Assert.hasText((String)defaultConversationId, (String)"defaultConversationId cannot be null or empty");
        Assert.notNull((Object)scheduler, (String)"scheduler cannot be null");
        Assert.notNull((Object)systemPromptTemplate, (String)"systemPromptTemplate cannot be null");
        this.chatMemory = chatMemory;
        this.defaultConversationId = defaultConversationId;
        this.order = order;
        this.scheduler = scheduler;
        this.systemPromptTemplate = systemPromptTemplate;
    }

    public static Builder builder(ChatMemory chatMemory) {
        return new Builder(chatMemory);
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public ChatClientRequest before(ChatClientRequest chatClientRequest, AdvisorChain advisorChain) {
        String conversationId = this.getConversationId(chatClientRequest.context(), this.defaultConversationId);
        List memoryMessages = this.chatMemory.get(conversationId);
        logger.debug("[PromptChatMemoryAdvisor.before] Memory before processing for conversationId={}: {}", (Object)conversationId, (Object)memoryMessages);
        String memory = memoryMessages.stream().filter(m -> m.getMessageType() == MessageType.USER || m.getMessageType() == MessageType.ASSISTANT).map(m -> String.valueOf(m.getMessageType()) + ":" + m.getText()).collect(Collectors.joining(System.lineSeparator()));
        SystemMessage systemMessage = chatClientRequest.prompt().getSystemMessage();
        String augmentedSystemText = this.systemPromptTemplate.render(Map.of("instructions", systemMessage.getText(), "memory", memory));
        ChatClientRequest processedChatClientRequest = chatClientRequest.mutate().prompt(chatClientRequest.prompt().augmentSystemMessage(augmentedSystemText)).build();
        UserMessage userMessage = processedChatClientRequest.prompt().getUserMessage();
        this.chatMemory.add(conversationId, (Message)userMessage);
        return processedChatClientRequest;
    }

    @Override
    public ChatClientResponse after(ChatClientResponse chatClientResponse, AdvisorChain advisorChain) {
        List assistantMessages = new ArrayList();
        assistantMessages = Optional.ofNullable(chatClientResponse).map(ChatClientResponse::chatResponse).filter(response -> response.getResults() != null && !response.getResults().isEmpty()).map(response -> response.getResults().stream().map(g -> g.getOutput()).collect(Collectors.toList())).orElse(List.of());
        if (!assistantMessages.isEmpty()) {
            this.chatMemory.add(this.getConversationId(chatClientResponse.context(), this.defaultConversationId), assistantMessages);
            if (logger.isDebugEnabled()) {
                logger.debug("[PromptChatMemoryAdvisor.after] Added ASSISTANT messages to memory for conversationId={}: {}", (Object)this.getConversationId(chatClientResponse.context(), this.defaultConversationId), assistantMessages);
                List memoryMessages = this.chatMemory.get(this.getConversationId(chatClientResponse.context(), this.defaultConversationId));
                logger.debug("[PromptChatMemoryAdvisor.after] Memory after ASSISTANT add for conversationId={}: {}", (Object)this.getConversationId(chatClientResponse.context(), this.defaultConversationId), (Object)memoryMessages);
            }
        }
        return chatClientResponse;
    }

    @Override
    public Flux<ChatClientResponse> adviseStream(ChatClientRequest chatClientRequest, StreamAdvisorChain streamAdvisorChain) {
        Scheduler scheduler = this.getScheduler();
        return Mono.just((Object)chatClientRequest).publishOn(scheduler).map(request -> this.before((ChatClientRequest)request, streamAdvisorChain)).flatMapMany(streamAdvisorChain::nextStream).transform(flux -> new ChatClientMessageAggregator().aggregateChatClientResponse((Flux<ChatClientResponse>)flux, response -> this.after((ChatClientResponse)response, streamAdvisorChain)));
    }

    public static final class Builder {
        private PromptTemplate systemPromptTemplate = DEFAULT_SYSTEM_PROMPT_TEMPLATE;
        private String conversationId = "default";
        private int order = -2147482648;
        private Scheduler scheduler = BaseAdvisor.DEFAULT_SCHEDULER;
        private ChatMemory chatMemory;

        private Builder(ChatMemory chatMemory) {
            this.chatMemory = chatMemory;
        }

        public Builder systemPromptTemplate(PromptTemplate systemPromptTemplate) {
            this.systemPromptTemplate = systemPromptTemplate;
            return this;
        }

        public Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public Builder scheduler(Scheduler scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        public Builder order(int order) {
            this.order = order;
            return this;
        }

        public PromptChatMemoryAdvisor build() {
            return new PromptChatMemoryAdvisor(this.chatMemory, this.conversationId, this.order, this.scheduler, this.systemPromptTemplate);
        }
    }
}

