/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.openai.autoconfigure;

import org.springframework.ai.model.openai.autoconfigure.OpenAiParentProperties;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class OpenAIAutoConfigurationUtil {
    private OpenAIAutoConfigurationUtil() {
    }

    @NonNull
    public static ResolvedConnectionProperties resolveConnectionProperties(OpenAiParentProperties commonProperties, OpenAiParentProperties modelProperties, String modelType) {
        String baseUrl = StringUtils.hasText((String)modelProperties.getBaseUrl()) ? modelProperties.getBaseUrl() : commonProperties.getBaseUrl();
        String apiKey = StringUtils.hasText((String)modelProperties.getApiKey()) ? modelProperties.getApiKey() : commonProperties.getApiKey();
        String projectId = StringUtils.hasText((String)modelProperties.getProjectId()) ? modelProperties.getProjectId() : commonProperties.getProjectId();
        String organizationId = StringUtils.hasText((String)modelProperties.getOrganizationId()) ? modelProperties.getOrganizationId() : commonProperties.getOrganizationId();
        HttpHeaders connectionHeaders = new HttpHeaders();
        if (StringUtils.hasText((String)projectId)) {
            connectionHeaders.add("OpenAI-Project", projectId);
        }
        if (StringUtils.hasText((String)organizationId)) {
            connectionHeaders.add("OpenAI-Organization", organizationId);
        }
        Assert.hasText((String)baseUrl, (String)("OpenAI base URL must be set.  Use the connection property: spring.ai.openai.base-url or spring.ai.openai." + modelType + ".base-url property."));
        Assert.hasText((String)apiKey, (String)("OpenAI API key must be set. Use the connection property: spring.ai.openai.api-key or spring.ai.openai." + modelType + ".api-key property."));
        return new ResolvedConnectionProperties(baseUrl, apiKey, connectionHeaders);
    }

    public record ResolvedConnectionProperties(String baseUrl, String apiKey, HttpHeaders headers) {
    }
}

