/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.openaisdk.autoconfigure;

import com.openai.azure.AzureOpenAIServiceVersion;
import com.openai.client.OpenAIClient;
import com.openai.client.OpenAIClientAsync;
import com.openai.credential.Credential;
import io.micrometer.observation.ObservationRegistry;
import java.net.Proxy;
import java.time.Duration;
import java.util.Map;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.model.openaisdk.autoconfigure.OpenAiSdkAutoConfigurationUtil;
import org.springframework.ai.model.openaisdk.autoconfigure.OpenAiSdkChatProperties;
import org.springframework.ai.model.openaisdk.autoconfigure.OpenAiSdkConnectionProperties;
import org.springframework.ai.model.tool.DefaultToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.ToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.autoconfigure.ToolCallingAutoConfiguration;
import org.springframework.ai.openaisdk.AbstractOpenAiSdkOptions;
import org.springframework.ai.openaisdk.OpenAiSdkChatModel;
import org.springframework.ai.openaisdk.setup.OpenAiSdkSetup;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={ToolCallingAutoConfiguration.class})
@EnableConfigurationProperties(value={OpenAiSdkConnectionProperties.class, OpenAiSdkChatProperties.class})
@ConditionalOnProperty(name={"spring.ai.model.chat"}, havingValue="openai-sdk", matchIfMissing=true)
public class OpenAiSdkChatAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public OpenAiSdkChatModel openAiChatModel(OpenAiSdkConnectionProperties commonProperties, OpenAiSdkChatProperties chatProperties, ToolCallingManager toolCallingManager, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ChatModelObservationConvention> observationConvention, ObjectProvider<ToolExecutionEligibilityPredicate> openAiToolExecutionEligibilityPredicate) {
        OpenAiSdkAutoConfigurationUtil.ResolvedConnectionProperties resolvedConnectionProperties = OpenAiSdkAutoConfigurationUtil.resolveConnectionProperties(commonProperties, chatProperties);
        OpenAIClient openAIClient = this.openAiClient(resolvedConnectionProperties);
        OpenAIClientAsync openAIClientAsync = this.openAiClientAsync(resolvedConnectionProperties);
        OpenAiSdkChatModel chatModel = new OpenAiSdkChatModel(openAIClient, openAIClientAsync, chatProperties.getOptions(), toolCallingManager, (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP), (ToolExecutionEligibilityPredicate)openAiToolExecutionEligibilityPredicate.getIfUnique(DefaultToolExecutionEligibilityPredicate::new));
        observationConvention.ifAvailable(arg_0 -> ((OpenAiSdkChatModel)chatModel).setObservationConvention(arg_0));
        return chatModel;
    }

    private OpenAIClient openAiClient(AbstractOpenAiSdkOptions resolved) {
        return OpenAiSdkSetup.setupSyncClient((String)resolved.getBaseUrl(), (String)resolved.getApiKey(), (Credential)resolved.getCredential(), (String)resolved.getMicrosoftDeploymentName(), (AzureOpenAIServiceVersion)resolved.getMicrosoftFoundryServiceVersion(), (String)resolved.getOrganizationId(), (boolean)resolved.isMicrosoftFoundry(), (boolean)resolved.isGitHubModels(), (String)resolved.getModel(), (Duration)resolved.getTimeout(), (Integer)resolved.getMaxRetries(), (Proxy)resolved.getProxy(), (Map)resolved.getCustomHeaders());
    }

    private OpenAIClientAsync openAiClientAsync(AbstractOpenAiSdkOptions resolved) {
        return OpenAiSdkSetup.setupAsyncClient((String)resolved.getBaseUrl(), (String)resolved.getApiKey(), (Credential)resolved.getCredential(), (String)resolved.getMicrosoftDeploymentName(), (AzureOpenAIServiceVersion)resolved.getMicrosoftFoundryServiceVersion(), (String)resolved.getOrganizationId(), (boolean)resolved.isMicrosoftFoundry(), (boolean)resolved.isGitHubModels(), (String)resolved.getModel(), (Duration)resolved.getTimeout(), (Integer)resolved.getMaxRetries(), (Proxy)resolved.getProxy(), (Map)resolved.getCustomHeaders());
    }
}

