/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.openaisdk.autoconfigure;

import org.springframework.ai.openaisdk.AbstractOpenAiSdkOptions;
import org.springframework.util.StringUtils;

public final class OpenAiSdkAutoConfigurationUtil {
    private OpenAiSdkAutoConfigurationUtil() {
    }

    public static ResolvedConnectionProperties resolveConnectionProperties(AbstractOpenAiSdkOptions commonProperties, AbstractOpenAiSdkOptions modelProperties) {
        ResolvedConnectionProperties resolved = new ResolvedConnectionProperties();
        resolved.setBaseUrl(StringUtils.hasText((String)modelProperties.getBaseUrl()) ? modelProperties.getBaseUrl() : commonProperties.getBaseUrl());
        resolved.setApiKey(StringUtils.hasText((String)modelProperties.getApiKey()) ? modelProperties.getApiKey() : commonProperties.getApiKey());
        String organizationId = StringUtils.hasText((String)modelProperties.getOrganizationId()) ? modelProperties.getOrganizationId() : commonProperties.getOrganizationId();
        resolved.setOrganizationId(organizationId);
        resolved.setCredential(modelProperties.getCredential() != null ? modelProperties.getCredential() : commonProperties.getCredential());
        resolved.setTimeout(modelProperties.getTimeout() != null ? modelProperties.getTimeout() : commonProperties.getTimeout());
        resolved.setModel(StringUtils.hasText((String)modelProperties.getModel()) ? modelProperties.getModel() : commonProperties.getModel());
        resolved.setMicrosoftDeploymentName(StringUtils.hasText((String)modelProperties.getMicrosoftDeploymentName()) ? modelProperties.getMicrosoftDeploymentName() : commonProperties.getMicrosoftDeploymentName());
        resolved.setMicrosoftFoundryServiceVersion(modelProperties.getMicrosoftFoundryServiceVersion() != null ? modelProperties.getMicrosoftFoundryServiceVersion() : commonProperties.getMicrosoftFoundryServiceVersion());
        resolved.setMicrosoftFoundry(modelProperties.isMicrosoftFoundry() || commonProperties.isMicrosoftFoundry());
        resolved.setGitHubModels(modelProperties.isGitHubModels() || commonProperties.isGitHubModels());
        resolved.setMaxRetries(modelProperties.getMaxRetries() != null ? modelProperties.getMaxRetries() : commonProperties.getMaxRetries());
        resolved.setProxy(modelProperties.getProxy() != null ? modelProperties.getProxy() : commonProperties.getProxy());
        resolved.setCustomHeaders(modelProperties.getCustomHeaders() != null ? modelProperties.getCustomHeaders() : commonProperties.getCustomHeaders());
        return resolved;
    }

    public static class ResolvedConnectionProperties
    extends AbstractOpenAiSdkOptions {
    }
}

