/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.oci.genai.autoconfigure;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import com.oracle.bmc.auth.InstancePrincipalsAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SimpleAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SimplePrivateKeySupplier;
import com.oracle.bmc.auth.okeworkloadidentity.OkeWorkloadIdentityAuthenticationDetailsProvider;
import com.oracle.bmc.generativeaiinference.GenerativeAiInferenceClient;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.io.IOException;
import java.util.function.Supplier;
import org.springframework.ai.model.oci.genai.autoconfigure.OCIConnectionProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnClass(value={GenerativeAiInferenceClient.class})
@EnableConfigurationProperties(value={OCIConnectionProperties.class})
public class OCIGenAiInferenceClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public GenerativeAiInferenceClient generativeAiInferenceClient(OCIConnectionProperties properties) throws IOException {
        ClientConfiguration clientConfiguration = ClientConfiguration.builder().retryConfiguration(RetryConfiguration.SDK_DEFAULT_RETRY_CONFIGURATION).build();
        GenerativeAiInferenceClient.Builder builder = (GenerativeAiInferenceClient.Builder)GenerativeAiInferenceClient.builder().configuration(clientConfiguration);
        if (StringUtils.hasText((String)properties.getRegion())) {
            builder.region(Region.valueOf((String)properties.getRegion()));
        }
        if (StringUtils.hasText((String)properties.getEndpoint())) {
            builder.endpoint(properties.getEndpoint());
        }
        return builder.build((AbstractAuthenticationDetailsProvider)OCIGenAiInferenceClientAutoConfiguration.authenticationProvider(properties));
    }

    private static BasicAuthenticationDetailsProvider authenticationProvider(OCIConnectionProperties properties) throws IOException {
        return switch (properties.getAuthenticationType()) {
            default -> throw new IncompatibleClassChangeError();
            case OCIConnectionProperties.AuthenticationType.FILE -> new ConfigFileAuthenticationDetailsProvider(properties.getFile(), properties.getProfile());
            case OCIConnectionProperties.AuthenticationType.INSTANCE_PRINCIPAL -> InstancePrincipalsAuthenticationDetailsProvider.builder().build();
            case OCIConnectionProperties.AuthenticationType.WORKLOAD_IDENTITY -> OkeWorkloadIdentityAuthenticationDetailsProvider.builder().build();
            case OCIConnectionProperties.AuthenticationType.SIMPLE -> SimpleAuthenticationDetailsProvider.builder().userId(properties.getUserId()).tenantId(properties.getTenantId()).fingerprint(properties.getFingerprint()).privateKeySupplier((Supplier)new SimplePrivateKeySupplier(properties.getPrivateKey())).passPhrase(properties.getPassPhrase()).region(Region.valueOf((String)properties.getRegion())).build();
        };
    }
}

