/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.oci.genai.autoconfigure;

import com.oracle.bmc.generativeaiinference.GenerativeAiInference;
import com.oracle.bmc.generativeaiinference.GenerativeAiInferenceClient;
import org.springframework.ai.model.oci.genai.autoconfigure.OCIEmbeddingModelProperties;
import org.springframework.ai.model.oci.genai.autoconfigure.OCIGenAiInferenceClientAutoConfiguration;
import org.springframework.ai.oci.OCIEmbeddingModel;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={OCIEmbeddingModel.class})
@EnableConfigurationProperties(value={OCIEmbeddingModelProperties.class})
@ConditionalOnProperty(name={"spring.ai.model.embedding"}, havingValue="oci-genai", matchIfMissing=true)
@ImportAutoConfiguration(value={OCIGenAiInferenceClientAutoConfiguration.class})
public class OCIGenAiEmbeddingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public OCIEmbeddingModel ociEmbeddingModel(GenerativeAiInferenceClient generativeAiClient, OCIEmbeddingModelProperties properties) {
        return new OCIEmbeddingModel((GenerativeAiInference)generativeAiClient, properties.getEmbeddingOptions());
    }
}

