/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.oci.genai.autoconfigure;

import com.oracle.bmc.generativeaiinference.GenerativeAiInference;
import com.oracle.bmc.generativeaiinference.GenerativeAiInferenceClient;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.model.oci.genai.autoconfigure.OCICohereChatModelProperties;
import org.springframework.ai.model.oci.genai.autoconfigure.OCIGenAiInferenceClientAutoConfiguration;
import org.springframework.ai.oci.cohere.OCICohereChatModel;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={OCICohereChatModel.class})
@EnableConfigurationProperties(value={OCICohereChatModelProperties.class})
@ConditionalOnProperty(name={"spring.ai.model.chat"}, havingValue="oci-genai", matchIfMissing=true)
@ImportAutoConfiguration(value={OCIGenAiInferenceClientAutoConfiguration.class})
public class OCIGenAiChatAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public OCICohereChatModel ociChatModel(GenerativeAiInferenceClient generativeAiClient, OCICohereChatModelProperties properties, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ChatModelObservationConvention> observationConvention) {
        OCICohereChatModel chatModel = new OCICohereChatModel((GenerativeAiInference)generativeAiClient, properties.getOptions(), (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
        observationConvention.ifAvailable(arg_0 -> ((OCICohereChatModel)chatModel).setObservationConvention(arg_0));
        return chatModel;
    }
}

