/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.oci.genai.autoconfigure;

import java.nio.file.Paths;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.ai.oci.genai")
public class OCIConnectionProperties {
    public static final String CONFIG_PREFIX = "spring.ai.oci.genai";
    private static final String DEFAULT_PROFILE = "DEFAULT";
    private AuthenticationType authenticationType = AuthenticationType.FILE;
    private String profile;
    private String file = Paths.get(System.getProperty("user.home"), ".oci", "config").toString();
    private String tenantId;
    private String userId;
    private String fingerprint;
    private String privateKey;
    private String passPhrase;
    private String region = "us-chicago-1";
    private String endpoint;

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(String passPhrase) {
        this.passPhrase = passPhrase;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getProfile() {
        return StringUtils.hasText((String)this.profile) ? this.profile : DEFAULT_PROFILE;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public static enum AuthenticationType {
        FILE("file"),
        INSTANCE_PRINCIPAL("instance-principal"),
        WORKLOAD_IDENTITY("workload-identity"),
        SIMPLE("simple");

        private final String authType;

        private AuthenticationType(String authType) {
            this.authType = authType;
        }

        public String getAuthType() {
            return this.authType;
        }
    }
}

