/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.chat.client.autoconfigure;

import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.tracing.Tracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.client.ChatClientCustomizer;
import org.springframework.ai.chat.client.advisor.observation.AdvisorObservationConvention;
import org.springframework.ai.chat.client.observation.ChatClientCompletionObservationHandler;
import org.springframework.ai.chat.client.observation.ChatClientObservationContext;
import org.springframework.ai.chat.client.observation.ChatClientObservationConvention;
import org.springframework.ai.chat.client.observation.ChatClientPromptContentObservationHandler;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.model.chat.client.autoconfigure.ChatClientBuilderConfigurer;
import org.springframework.ai.model.chat.client.autoconfigure.ChatClientBuilderProperties;
import org.springframework.ai.observation.TracingAwareLoggingObservationHandler;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@AutoConfiguration(afterName={"org.springframework.boot.actuate.autoconfigure.observation.ObservationAutoConfiguration"})
@ConditionalOnClass(value={ChatClient.class})
@EnableConfigurationProperties(value={ChatClientBuilderProperties.class})
@ConditionalOnProperty(prefix="spring.ai.chat.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class ChatClientAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ChatClientAutoConfiguration.class);

    private static void logPromptContentWarning() {
        logger.warn("You have enabled logging out the ChatClient prompt content with the risk of exposing sensitive or private information. Please, be careful!");
    }

    private static void logCompletionWarning() {
        logger.warn("You have enabled logging out the ChatClient completion content with the risk of exposing sensitive or private information. Please, be careful!");
    }

    @Bean
    @ConditionalOnMissingBean
    ChatClientBuilderConfigurer chatClientBuilderConfigurer(ObjectProvider<ChatClientCustomizer> customizerProvider) {
        ChatClientBuilderConfigurer configurer = new ChatClientBuilderConfigurer();
        configurer.setChatClientCustomizers(customizerProvider.orderedStream().toList());
        return configurer;
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    ChatClient.Builder chatClientBuilder(ChatClientBuilderConfigurer chatClientBuilderConfigurer, ChatModel chatModel, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ChatClientObservationConvention> chatClientObservationConvention, ObjectProvider<AdvisorObservationConvention> advisorObservationConvention) {
        ChatClient.Builder builder = ChatClient.builder((ChatModel)chatModel, (ObservationRegistry)((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP)), (ChatClientObservationConvention)((ChatClientObservationConvention)chatClientObservationConvention.getIfUnique(() -> null)), (AdvisorObservationConvention)((AdvisorObservationConvention)advisorObservationConvention.getIfUnique(() -> null)));
        return chatClientBuilderConfigurer.configure(builder);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"io.micrometer.tracing.Tracer"})
    static class TracerNotPresentObservationConfiguration {
        TracerNotPresentObservationConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.ai.chat.client.observations", name={"log-prompt"}, havingValue="true")
        ChatClientPromptContentObservationHandler chatClientPromptContentObservationHandler() {
            ChatClientAutoConfiguration.logPromptContentWarning();
            return new ChatClientPromptContentObservationHandler();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.ai.chat.client.observations", name={"log-completion"}, havingValue="true")
        ChatClientCompletionObservationHandler chatClientCompletionObservationHandler() {
            ChatClientAutoConfiguration.logCompletionWarning();
            return new ChatClientCompletionObservationHandler();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Tracer.class})
    @ConditionalOnBean(value={Tracer.class})
    static class TracerPresentObservationConfiguration {
        TracerPresentObservationConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ChatClientPromptContentObservationHandler.class}, name={"chatClientPromptContentObservationHandler"})
        @ConditionalOnProperty(prefix="spring.ai.chat.client.observations", name={"log-prompt"}, havingValue="true")
        TracingAwareLoggingObservationHandler<ChatClientObservationContext> chatClientPromptContentObservationHandler(Tracer tracer) {
            ChatClientAutoConfiguration.logPromptContentWarning();
            return new TracingAwareLoggingObservationHandler((ObservationHandler)new ChatClientPromptContentObservationHandler(), tracer);
        }

        @Bean
        @ConditionalOnMissingBean(value={ChatClientCompletionObservationHandler.class}, name={"chatClientCompletionObservationHandler"})
        @ConditionalOnProperty(prefix="spring.ai.chat.client.observations", name={"log-completion"}, havingValue="true")
        TracingAwareLoggingObservationHandler<ChatClientObservationContext> chatClientCompletionObservationHandler(Tracer tracer) {
            ChatClientAutoConfiguration.logCompletionWarning();
            return new TracingAwareLoggingObservationHandler((ObservationHandler)new ChatClientCompletionObservationHandler(), tracer);
        }
    }
}

