/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.bedrock.cohere.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.ai.bedrock.cohere.BedrockCohereEmbeddingModel;
import org.springframework.ai.bedrock.cohere.api.CohereEmbeddingBedrockApi;
import org.springframework.ai.model.bedrock.autoconfigure.BedrockAwsConnectionConfiguration;
import org.springframework.ai.model.bedrock.autoconfigure.BedrockAwsConnectionProperties;
import org.springframework.ai.model.bedrock.cohere.autoconfigure.BedrockCohereEmbeddingProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;

@AutoConfiguration
@ConditionalOnClass(value={CohereEmbeddingBedrockApi.class})
@EnableConfigurationProperties(value={BedrockCohereEmbeddingProperties.class, BedrockAwsConnectionProperties.class})
@ConditionalOnProperty(name={"spring.ai.model.embedding"}, havingValue="bedrock-cohere", matchIfMissing=true)
@Import(value={BedrockAwsConnectionConfiguration.class})
public class BedrockCohereEmbeddingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={AwsCredentialsProvider.class, AwsRegionProvider.class})
    public CohereEmbeddingBedrockApi cohereEmbeddingApi(AwsCredentialsProvider credentialsProvider, AwsRegionProvider regionProvider, BedrockCohereEmbeddingProperties properties, BedrockAwsConnectionProperties awsProperties, ObjectMapper objectMapper) {
        return new CohereEmbeddingBedrockApi(properties.getModel(), credentialsProvider, regionProvider.getRegion(), objectMapper, awsProperties.getTimeout());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={CohereEmbeddingBedrockApi.class})
    public BedrockCohereEmbeddingModel cohereEmbeddingModel(CohereEmbeddingBedrockApi cohereEmbeddingApi, BedrockCohereEmbeddingProperties properties) {
        return new BedrockCohereEmbeddingModel(cohereEmbeddingApi, properties.getOptions());
    }
}

