/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.azure.openai.autoconfigure;

import org.springframework.ai.azure.openai.AzureOpenAiEmbeddingOptions;
import org.springframework.ai.document.MetadataMode;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.Assert;

@ConfigurationProperties(value="spring.ai.azure.openai.embedding")
public class AzureOpenAiEmbeddingProperties {
    public static final String CONFIG_PREFIX = "spring.ai.azure.openai.embedding";
    @NestedConfigurationProperty
    private final AzureOpenAiEmbeddingOptions options = AzureOpenAiEmbeddingOptions.builder().deploymentName("text-embedding-ada-002").build();
    private MetadataMode metadataMode = MetadataMode.EMBED;

    public AzureOpenAiEmbeddingOptions getOptions() {
        return this.options;
    }

    public MetadataMode getMetadataMode() {
        return this.metadataMode;
    }

    public void setMetadataMode(MetadataMode metadataMode) {
        Assert.notNull((Object)metadataMode, (String)"Metadata mode must not be null");
        this.metadataMode = metadataMode;
    }
}

