/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.azure.openai.autoconfigure;

import com.azure.ai.openai.OpenAIClientBuilder;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.ai.azure.openai.AzureOpenAiEmbeddingModel;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.model.azure.openai.autoconfigure.AzureOpenAiClientBuilderConfiguration;
import org.springframework.ai.model.azure.openai.autoconfigure.AzureOpenAiEmbeddingProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@AutoConfiguration
@ConditionalOnClass(value={AzureOpenAiEmbeddingModel.class})
@EnableConfigurationProperties(value={AzureOpenAiEmbeddingProperties.class})
@ConditionalOnProperty(name={"spring.ai.model.embedding"}, havingValue="azure-openai", matchIfMissing=true)
@Import(value={AzureOpenAiClientBuilderConfiguration.class})
public class AzureOpenAiEmbeddingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public AzureOpenAiEmbeddingModel azureOpenAiEmbeddingModel(OpenAIClientBuilder openAIClient, AzureOpenAiEmbeddingProperties embeddingProperties, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<EmbeddingModelObservationConvention> observationConvention) {
        AzureOpenAiEmbeddingModel embeddingModel = new AzureOpenAiEmbeddingModel(openAIClient.buildClient(), embeddingProperties.getMetadataMode(), embeddingProperties.getOptions(), (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
        observationConvention.ifAvailable(arg_0 -> ((AzureOpenAiEmbeddingModel)embeddingModel).setObservationConvention(arg_0));
        return embeddingModel;
    }
}

