/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.server.autoconfigure;

import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.server.transport.StdioServerTransportProvider;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.springframework.ai.mcp.McpToolUtils;
import org.springframework.ai.mcp.server.autoconfigure.McpServerProperties;
import org.springframework.ai.mcp.server.autoconfigure.McpWebFluxServerAutoConfiguration;
import org.springframework.ai.mcp.server.autoconfigure.McpWebMvcServerAutoConfiguration;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import reactor.core.publisher.Mono;

@AutoConfiguration(after={McpWebMvcServerAutoConfiguration.class, McpWebFluxServerAutoConfiguration.class})
@ConditionalOnClass(value={McpSchema.class, McpSyncServer.class})
@EnableConfigurationProperties(value={McpServerProperties.class})
@ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class McpServerAutoConfiguration {
    private static final LogAccessor logger = new LogAccessor(McpServerAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public McpServerTransportProvider stdioServerTransport() {
        return new StdioServerTransportProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    public McpSchema.ServerCapabilities.Builder capabilitiesBuilder() {
        return McpSchema.ServerCapabilities.builder();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    public List<McpServerFeatures.SyncToolSpecification> syncTools(ObjectProvider<List<ToolCallback>> toolCalls, List<ToolCallback> toolCallbacksList, McpServerProperties serverProperties) {
        ArrayList<ToolCallback> tools = new ArrayList<ToolCallback>(toolCalls.stream().flatMap(Collection::stream).toList());
        if (!CollectionUtils.isEmpty(toolCallbacksList)) {
            tools.addAll(toolCallbacksList);
        }
        return this.toSyncToolSpecifications(tools, serverProperties);
    }

    private List<McpServerFeatures.SyncToolSpecification> toSyncToolSpecifications(List<ToolCallback> tools, McpServerProperties serverProperties) {
        return tools.stream().collect(Collectors.toMap(tool -> tool.getToolDefinition().name(), tool -> tool, (existing, replacement) -> existing)).values().stream().map(tool -> {
            String toolName = tool.getToolDefinition().name();
            MimeType mimeType = serverProperties.getToolResponseMimeType().containsKey(toolName) ? MimeType.valueOf((String)serverProperties.getToolResponseMimeType().get(toolName)) : null;
            return McpToolUtils.toSyncToolSpecification((ToolCallback)tool, mimeType);
        }).toList();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    public McpSyncServer mcpSyncServer(McpServerTransportProvider transportProvider, McpSchema.ServerCapabilities.Builder capabilitiesBuilder, McpServerProperties serverProperties, ObjectProvider<List<McpServerFeatures.SyncToolSpecification>> tools, ObjectProvider<List<McpServerFeatures.SyncResourceSpecification>> resources, ObjectProvider<List<McpServerFeatures.SyncPromptSpecification>> prompts, ObjectProvider<List<McpServerFeatures.SyncCompletionSpecification>> completions, ObjectProvider<BiConsumer<McpSyncServerExchange, List<McpSchema.Root>>> rootsChangeConsumers, List<ToolCallbackProvider> toolCallbackProvider) {
        List completionSpecifications;
        List promptSpecifications;
        List resourceSpecifications;
        McpSchema.Implementation serverInfo = new McpSchema.Implementation(serverProperties.getName(), serverProperties.getVersion());
        McpServer.SyncSpecification serverBuilder = McpServer.sync((McpServerTransportProvider)transportProvider).serverInfo(serverInfo);
        ArrayList toolSpecifications = new ArrayList(tools.stream().flatMap(Collection::stream).toList());
        List<ToolCallback> providerToolCallbacks = toolCallbackProvider.stream().map(pr -> List.of(pr.getToolCallbacks())).flatMap(Collection::stream).filter(fc -> fc instanceof ToolCallback).map(fc -> fc).toList();
        toolSpecifications.addAll(this.toSyncToolSpecifications(providerToolCallbacks, serverProperties));
        if (!CollectionUtils.isEmpty(toolSpecifications)) {
            serverBuilder.tools(toolSpecifications);
            capabilitiesBuilder.tools(Boolean.valueOf(serverProperties.isToolChangeNotification()));
            logger.info((CharSequence)("Registered tools: " + toolSpecifications.size() + ", notification: " + serverProperties.isToolChangeNotification()));
        }
        if (!CollectionUtils.isEmpty(resourceSpecifications = resources.stream().flatMap(Collection::stream).toList())) {
            serverBuilder.resources(resourceSpecifications);
            capabilitiesBuilder.resources(Boolean.valueOf(false), Boolean.valueOf(serverProperties.isResourceChangeNotification()));
            logger.info((CharSequence)("Registered resources: " + resourceSpecifications.size() + ", notification: " + serverProperties.isResourceChangeNotification()));
        }
        if (!CollectionUtils.isEmpty(promptSpecifications = prompts.stream().flatMap(Collection::stream).toList())) {
            serverBuilder.prompts(promptSpecifications);
            capabilitiesBuilder.prompts(Boolean.valueOf(serverProperties.isPromptChangeNotification()));
            logger.info((CharSequence)("Registered prompts: " + promptSpecifications.size() + ", notification: " + serverProperties.isPromptChangeNotification()));
        }
        if (!CollectionUtils.isEmpty(completionSpecifications = completions.stream().flatMap(Collection::stream).toList())) {
            serverBuilder.completions(completionSpecifications);
            capabilitiesBuilder.completions();
            logger.info((CharSequence)("Registered completions: " + completionSpecifications.size()));
        }
        rootsChangeConsumers.ifAvailable(consumer -> {
            serverBuilder.rootsChangeHandler((exchange, roots) -> consumer.accept(exchange, roots));
            logger.info((CharSequence)"Registered roots change consumer");
        });
        serverBuilder.capabilities(capabilitiesBuilder.build());
        serverBuilder.instructions(serverProperties.getInstructions());
        return serverBuilder.build();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="ASYNC")
    public List<McpServerFeatures.AsyncToolSpecification> asyncTools(ObjectProvider<List<ToolCallback>> toolCalls, List<ToolCallback> toolCallbackList, McpServerProperties serverProperties) {
        ArrayList<ToolCallback> tools = new ArrayList<ToolCallback>(toolCalls.stream().flatMap(Collection::stream).toList());
        if (!CollectionUtils.isEmpty(toolCallbackList)) {
            tools.addAll(toolCallbackList);
        }
        return this.toAsyncToolSpecification(tools, serverProperties);
    }

    private List<McpServerFeatures.AsyncToolSpecification> toAsyncToolSpecification(List<ToolCallback> tools, McpServerProperties serverProperties) {
        return tools.stream().collect(Collectors.toMap(tool -> tool.getToolDefinition().name(), tool -> tool, (existing, replacement) -> existing)).values().stream().map(tool -> {
            String toolName = tool.getToolDefinition().name();
            MimeType mimeType = serverProperties.getToolResponseMimeType().containsKey(toolName) ? MimeType.valueOf((String)serverProperties.getToolResponseMimeType().get(toolName)) : null;
            return McpToolUtils.toAsyncToolSpecification((ToolCallback)tool, mimeType);
        }).toList();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="ASYNC")
    public McpAsyncServer mcpAsyncServer(McpServerTransportProvider transportProvider, McpSchema.ServerCapabilities.Builder capabilitiesBuilder, McpServerProperties serverProperties, ObjectProvider<List<McpServerFeatures.AsyncToolSpecification>> tools, ObjectProvider<List<McpServerFeatures.AsyncResourceSpecification>> resources, ObjectProvider<List<McpServerFeatures.AsyncPromptSpecification>> prompts, ObjectProvider<List<McpServerFeatures.AsyncCompletionSpecification>> completions, ObjectProvider<BiConsumer<McpAsyncServerExchange, List<McpSchema.Root>>> rootsChangeConsumer, List<ToolCallbackProvider> toolCallbackProvider) {
        List completionSpecifications;
        List promptSpecifications;
        List resourceSpecifications;
        McpSchema.Implementation serverInfo = new McpSchema.Implementation(serverProperties.getName(), serverProperties.getVersion());
        McpServer.AsyncSpecification serverBuilder = McpServer.async((McpServerTransportProvider)transportProvider).serverInfo(serverInfo);
        ArrayList toolSpecifications = new ArrayList(tools.stream().flatMap(Collection::stream).toList());
        List<ToolCallback> providerToolCallbacks = toolCallbackProvider.stream().map(pr -> List.of(pr.getToolCallbacks())).flatMap(Collection::stream).filter(fc -> fc instanceof ToolCallback).map(fc -> fc).toList();
        toolSpecifications.addAll(this.toAsyncToolSpecification(providerToolCallbacks, serverProperties));
        if (!CollectionUtils.isEmpty(toolSpecifications)) {
            serverBuilder.tools(toolSpecifications);
            capabilitiesBuilder.tools(Boolean.valueOf(serverProperties.isToolChangeNotification()));
            logger.info((CharSequence)("Registered tools: " + toolSpecifications.size() + ", notification: " + serverProperties.isToolChangeNotification()));
        }
        if (!CollectionUtils.isEmpty(resourceSpecifications = resources.stream().flatMap(Collection::stream).toList())) {
            serverBuilder.resources(resourceSpecifications);
            capabilitiesBuilder.resources(Boolean.valueOf(false), Boolean.valueOf(serverProperties.isResourceChangeNotification()));
            logger.info((CharSequence)("Registered resources: " + resourceSpecifications.size() + ", notification: " + serverProperties.isResourceChangeNotification()));
        }
        if (!CollectionUtils.isEmpty(promptSpecifications = prompts.stream().flatMap(Collection::stream).toList())) {
            serverBuilder.prompts(promptSpecifications);
            capabilitiesBuilder.prompts(Boolean.valueOf(serverProperties.isPromptChangeNotification()));
            logger.info((CharSequence)("Registered prompts: " + promptSpecifications.size() + ", notification: " + serverProperties.isPromptChangeNotification()));
        }
        if (!CollectionUtils.isEmpty(completionSpecifications = completions.stream().flatMap(Collection::stream).toList())) {
            serverBuilder.completions(completionSpecifications);
            capabilitiesBuilder.completions();
            logger.info((CharSequence)("Registered completions: " + completionSpecifications.size()));
        }
        rootsChangeConsumer.ifAvailable(consumer -> {
            BiFunction<McpAsyncServerExchange, List, Mono> asyncConsumer = (exchange, roots) -> {
                consumer.accept(exchange, roots);
                return Mono.empty();
            };
            serverBuilder.rootsChangeHandler(asyncConsumer);
            logger.info((CharSequence)"Registered roots change consumer");
        });
        serverBuilder.capabilities(capabilitiesBuilder.build());
        serverBuilder.instructions(serverProperties.getInstructions());
        return serverBuilder.build();
    }
}

