/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.server.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.json.McpJsonMapper;
import io.modelcontextprotocol.json.jackson.JacksonMcpJsonMapper;
import io.modelcontextprotocol.server.transport.WebFluxSseServerTransportProvider;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import org.springframework.ai.mcp.server.common.autoconfigure.McpServerAutoConfiguration;
import org.springframework.ai.mcp.server.common.autoconfigure.McpServerStdioDisabledCondition;
import org.springframework.ai.mcp.server.common.autoconfigure.properties.McpServerSseProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.web.reactive.function.server.RouterFunction;

@AutoConfiguration(before={McpServerAutoConfiguration.class})
@EnableConfigurationProperties(value={McpServerSseProperties.class})
@ConditionalOnClass(value={WebFluxSseServerTransportProvider.class})
@ConditionalOnMissingBean(value={McpServerTransportProvider.class})
@Conditional(value={McpServerStdioDisabledCondition.class, McpServerAutoConfiguration.EnabledSseServerCondition.class})
public class McpServerSseWebFluxAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public WebFluxSseServerTransportProvider webFluxTransport(ObjectProvider<ObjectMapper> objectMapperProvider, McpServerSseProperties serverProperties) {
        ObjectMapper objectMapper = (ObjectMapper)objectMapperProvider.getIfAvailable(ObjectMapper::new);
        return WebFluxSseServerTransportProvider.builder().jsonMapper((McpJsonMapper)new JacksonMcpJsonMapper(objectMapper)).basePath(serverProperties.getBaseUrl()).messageEndpoint(serverProperties.getSseMessageEndpoint()).sseEndpoint(serverProperties.getSseEndpoint()).keepAliveInterval(serverProperties.getKeepAliveInterval()).build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"webfluxSseServerRouterFunction"})
    public RouterFunction<?> webfluxSseServerRouterFunction(WebFluxSseServerTransportProvider webFluxProvider) {
        return webFluxProvider.getRouterFunction();
    }
}

