/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.anthropic;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.ai.anthropic.api.AnthropicApi;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.util.Assert;

public final class SkillsResponseHelper {
    private SkillsResponseHelper() {
    }

    public static List<String> extractFileIds(ChatResponse response) {
        Object anthropicResponse;
        if (response == null) {
            return List.of();
        }
        ArrayList<String> fileIds = new ArrayList<String>();
        if (response.getMetadata() != null && (anthropicResponse = response.getMetadata().get("anthropic-response")) instanceof AnthropicApi.ChatCompletionResponse) {
            AnthropicApi.ChatCompletionResponse chatCompletionResponse = (AnthropicApi.ChatCompletionResponse)anthropicResponse;
            fileIds.addAll(SkillsResponseHelper.extractFileIdsFromContentBlocks(chatCompletionResponse.content()));
        }
        return fileIds;
    }

    public static String extractContainerId(ChatResponse response) {
        AnthropicApi.ChatCompletionResponse chatCompletionResponse;
        Object anthropicResponse;
        if (response == null) {
            return null;
        }
        if (response.getMetadata() != null && (anthropicResponse = response.getMetadata().get("anthropic-response")) instanceof AnthropicApi.ChatCompletionResponse && (chatCompletionResponse = (AnthropicApi.ChatCompletionResponse)anthropicResponse).container() != null) {
            return chatCompletionResponse.container().id();
        }
        return null;
    }

    public static List<Path> downloadAllFiles(ChatResponse response, AnthropicApi api, Path targetDir) throws IOException {
        Assert.notNull((Object)response, (String)"Response cannot be null");
        Assert.notNull((Object)api, (String)"AnthropicApi cannot be null");
        Assert.notNull((Object)targetDir, (String)"Target directory cannot be null");
        Assert.isTrue((boolean)Files.isDirectory(targetDir, new LinkOption[0]), (String)"Target path must be a directory");
        List<String> fileIds = SkillsResponseHelper.extractFileIds(response);
        ArrayList<Path> savedPaths = new ArrayList<Path>();
        for (String fileId : fileIds) {
            AnthropicApi.FileMetadata metadata = api.getFileMetadata(fileId);
            byte[] content = api.downloadFile(fileId);
            Path filePath = targetDir.resolve(metadata.filename());
            Files.write(filePath, content, new OpenOption[0]);
            savedPaths.add(filePath);
        }
        return savedPaths;
    }

    private static List<String> extractFileIdsFromContentBlocks(List<AnthropicApi.ContentBlock> contentBlocks) {
        if (contentBlocks == null || contentBlocks.isEmpty()) {
            return List.of();
        }
        ArrayList<String> fileIds = new ArrayList<String>();
        for (AnthropicApi.ContentBlock block : contentBlocks) {
            if (block.type() == AnthropicApi.ContentBlock.Type.FILE && block.fileId() != null) {
                fileIds.add(block.fileId());
            }
            if (block.content() == null) continue;
            fileIds.addAll(SkillsResponseHelper.extractFileIdsFromObject(block.content()));
        }
        return fileIds;
    }

    private static List<String> extractFileIdsFromObject(Object obj) {
        ArrayList<String> fileIds;
        block4: {
            block3: {
                Object v;
                fileIds = new ArrayList<String>();
                if (!(obj instanceof Map)) break block3;
                Map map = (Map)obj;
                if (map.containsKey("file_id") && (v = map.get("file_id")) instanceof String) {
                    String fileId = (String)v;
                    fileIds.add(fileId);
                }
                for (Object value : map.values()) {
                    fileIds.addAll(SkillsResponseHelper.extractFileIdsFromObject(value));
                }
                break block4;
            }
            if (!(obj instanceof List)) break block4;
            List list = (List)obj;
            for (Object item : list) {
                fileIds.addAll(SkillsResponseHelper.extractFileIdsFromObject(item));
            }
        }
        return fileIds;
    }
}

